@extends('layouts.admin')

@section('title', 'Yeni Extra Ekle')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item"><a href="{{ route('admin.settings.extras.index') }}">Extra Yönetimi</a></li>
    <li class="breadcrumb-item active">Yeni Extra</li>
@endsection

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2>Yeni Extra Ekle</h2>
        <a href="{{ route('admin.settings.extras.index') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> Geri
        </a>
    </div>
    
    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0"><i class="bi bi-plus-circle"></i> Extra Bilgileri</h5>
        </div>
        <div class="card-body">
            <form method="POST" action="{{ route('admin.settings.extras.store') }}">
                @csrf
                
                <div class="mb-3">
                    <label class="form-label fw-bold">Extra Adı *</label>
                    <input type="text" name="name" class="form-control form-control-lg" value="{{ old('name') }}" required>
                </div>
                
                <div class="mb-3">
                    <label class="form-label fw-bold">Açıklama</label>
                    <textarea name="description" class="form-control" rows="4">{{ old('description') }}</textarea>
                </div>
                
                <div class="mb-3">
                    <label class="form-label fw-bold">Fiyat *</label>
                    <div class="input-group input-group-lg">
                        <input type="number" step="0.01" name="price" class="form-control" value="{{ old('price', 0) }}" min="0" required>
                        <span class="input-group-text">₺</span>
                    </div>
                </div>
                
                <div class="mb-3">
                    <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" name="is_active" id="is_active" value="1" {{ old('is_active', true) ? 'checked' : '' }}>
                        <label class="form-check-label fw-bold" for="is_active">
                            Aktif
                        </label>
                    </div>
                </div>
                
                <div class="d-flex justify-content-end gap-2">
                    <a href="{{ route('admin.settings.extras.index') }}" class="btn btn-lg btn-secondary">
                        <i class="bi bi-x-circle"></i> İptal
                    </a>
                    <button type="submit" class="btn btn-lg btn-primary">
                        <i class="bi bi-check-circle"></i> Kaydet
                    </button>
                </div>
            </form>
        </div>
    </div>
@endsection

