@extends('layouts.admin')

@section('title', 'Genel Ayarlar')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-2 fw-bold" style="background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent; background-clip: text;">
                <i class="bi bi-gear me-2"></i> Genel Ayarlar
            </h1>
            <p class="text-muted mb-0">Sistem genel ayarları ve yapılandırmaları</p>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="bi bi-check-circle"></i> {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="card">
        <div class="card-header border-0" style="background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);">
            <h5 class="mb-0 text-white"><i class="bi bi-telephone"></i> İletişim Bilgileri</h5>
        </div>
        <div class="card-body">
            <form method="POST" action="{{ route('admin.settings.general.update') }}">
                @csrf
                
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label for="phone" class="form-label">Telefon Numarası <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="phone" name="phone" 
                               value="{{ $settings['phone'] ?? '0850 811 08 20' }}" 
                               placeholder="0850 811 08 20" required>
                        <small class="form-text text-muted">Bu telefon numarası ana sayfada ve iletişim sayfalarında gösterilecektir.</small>
                    </div>
                    <div class="col-md-6">
                        <label for="email" class="form-label">E-posta Adresi</label>
                        <input type="email" class="form-control" id="email" name="email" 
                               value="{{ $settings['email'] ?? '' }}" 
                               placeholder="info@adugun.com">
                        <small class="form-text text-muted">Genel iletişim e-posta adresi.</small>
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-6">
                        <label for="address" class="form-label">Adres</label>
                        <textarea class="form-control" id="address" name="address" rows="3" 
                                  placeholder="Şirket adresi">{{ $settings['address'] ?? '' }}</textarea>
                    </div>
                    <div class="col-md-6">
                        <label for="company_name" class="form-label">Şirket Adı</label>
                        <input type="text" class="form-control" id="company_name" name="company_name" 
                               value="{{ $settings['company_name'] ?? 'Adugun' }}" 
                               placeholder="Adugun">
                    </div>
                </div>

                <div class="d-flex justify-content-end">
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-save"></i> Kaydet
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Uygulama İndirme Linkleri -->
    <div class="card mt-4">
        <div class="card-header border-0" style="background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%);">
            <h5 class="mb-0 text-white"><i class="bi bi-download"></i> Uygulama İndirme Linkleri</h5>
        </div>
        <div class="card-body">
            <form method="POST" action="{{ route('admin.settings.general.update') }}">
                @csrf
                
                <div class="row mb-3">
                    <div class="col-md-12">
                        <label for="android_download_url" class="form-label">
                            <i class="bi bi-android2 text-success me-2"></i>Android İndirme Linki
                        </label>
                        <input type="url" class="form-control" id="android_download_url" name="android_download_url" 
                               value="{{ \App\Models\Setting::where('group', 'apps')->where('key', 'android_download_url')->value('value') ?? '' }}" 
                               placeholder="https://play.google.com/store/apps/details?id=...">
                        <small class="form-text text-muted">Google Play Store veya APK indirme linki</small>
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-12">
                        <label for="ios_download_url" class="form-label">
                            <i class="bi bi-apple text-dark me-2"></i>iOS İndirme Linki
                        </label>
                        <input type="url" class="form-control" id="ios_download_url" name="ios_download_url" 
                               value="{{ \App\Models\Setting::where('group', 'apps')->where('key', 'ios_download_url')->value('value') ?? '' }}" 
                               placeholder="https://apps.apple.com/app/...">
                        <small class="form-text text-muted">App Store indirme linki</small>
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-12">
                        <label class="form-label">
                            <i class="bi bi-windows text-primary me-2"></i>Windows Setup Dosyası
                        </label>
                        <div class="alert alert-info">
                            <i class="bi bi-info-circle me-2"></i>
                            Windows setup dosyasını <code>storage/Adugun Setup.exe</code> veya <code>storage/app/public/Adugun Setup.exe</code> konumuna yükleyin.
                            @php
                                $fileExists = false;
                                if (file_exists(storage_path('Adugun Setup.exe'))) {
                                    $fileExists = true;
                                } elseif (file_exists(storage_path('app/public/Adugun Setup.exe'))) {
                                    $fileExists = true;
                                } elseif (file_exists(storage_path('app/public/windows-setup.exe'))) {
                                    $fileExists = true;
                                }
                            @endphp
                            @if($fileExists)
                                <span class="badge bg-success ms-2">Dosya mevcut</span>
                            @else
                                <span class="badge bg-warning ms-2">Dosya bulunamadı</span>
                            @endif
                        </div>
                    </div>
                </div>

                <div class="d-flex justify-content-end">
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-save"></i> Kaydet
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
