@extends('layouts.admin')

@section('title', 'Ana Sayfa Ayarları')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0"><i class="bi bi-house"></i> Ana Sayfa Ayarları</h1>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show">
            <i class="bi bi-check-circle"></i> {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="card shadow-sm">
        <div class="card-body">
            <form action="{{ route('admin.settings.homepage.update') }}" method="POST">
                @csrf
                
                <h5 class="mb-3"><i class="bi bi-megaphone"></i> İndirim Kutusu</h5>
                <div class="mb-4 p-4 border rounded bg-light">
                    <div class="form-check form-switch mb-4">
                        <input type="hidden" name="show_promo_banner" value="0">
                        <input class="form-check-input" type="checkbox" name="show_promo_banner" id="show_promo_banner" value="1" {{ ($settings['show_promo_banner'] ?? '0') === '1' ? 'checked' : '' }}>
                        <label class="form-check-label" for="show_promo_banner">
                            <strong>İndirim Kutusunu Göster</strong>
                        </label>
                        <small class="d-block text-muted">Ana sayfanın hero bölümünde indirim kutusunu gösterir/gizler</small>
                    </div>
                    
                    <div id="promoContentFields">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="promo_title" class="form-label">Başlık <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="promo_title" name="promo_title" value="{{ $settings['promo_title'] ?? 'Özel İndirim Fırsatı!' }}" required>
                                <small class="text-muted">İndirim kutusunun başlığı</small>
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label for="promo_subtitle" class="form-label">Alt Başlık</label>
                                <input type="text" class="form-control" id="promo_subtitle" name="promo_subtitle" value="{{ $settings['promo_subtitle'] ?? 'Hemen kayıt ol, özel avantajlardan yararlan!' }}">
                                <small class="text-muted">Başlığın altında gösterilecek metin</small>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="promo_button_text" class="form-label">Buton Metni</label>
                                <input type="text" class="form-control" id="promo_button_text" name="promo_button_text" value="{{ $settings['promo_button_text'] ?? 'Hemen Başla' }}">
                                <small class="text-muted">Buton üzerinde görünecek metin</small>
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label for="promo_button_link" class="form-label">Buton Linki</label>
                                <input type="text" class="form-control" id="promo_button_link" name="promo_button_link" value="{{ $settings['promo_button_link'] ?? '/kayit' }}">
                                <small class="text-muted">Butona tıklandığında yönlendirilecek sayfa (örn: /kayit)</small>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label for="promo_description" class="form-label">Açıklama</label>
                            <textarea class="form-control" id="promo_description" name="promo_description" rows="3">{{ $settings['promo_description'] ?? 'Sınırsız rezervasyon yönetimi ve daha fazlası için hemen kayıt olun!' }}</textarea>
                            <small class="text-muted">İndirim kutusunda gösterilecek detaylı açıklama</small>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="promo_discount_text" class="form-label">İndirim Metni</label>
                                <input type="text" class="form-control" id="promo_discount_text" name="promo_discount_text" value="{{ $settings['promo_discount_text'] ?? '%50 İndirim' }}">
                                <small class="text-muted">Vurgulanacak indirim yüzdesi veya metni</small>
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label for="promo_bg_color" class="form-label">Arka Plan Rengi</label>
                                <input type="color" class="form-control form-control-color" id="promo_bg_color" name="promo_bg_color" value="{{ $settings['promo_bg_color'] ?? '#2563eb' }}">
                                <small class="text-muted">İndirim kutusunun arka plan rengi</small>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="mt-4">
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-save"></i> Kaydet
                    </button>
                </div>
            </form>
        </div>
    </div>
    
    <script>
        // Checkbox değiştiğinde içerik alanlarını göster/gizle
        document.getElementById('show_promo_banner').addEventListener('change', function() {
            const contentFields = document.getElementById('promoContentFields');
            if (this.checked) {
                contentFields.style.display = 'block';
            } else {
                contentFields.style.display = 'none';
            }
        });
        
        // Sayfa yüklendiğinde kontrol et
        window.addEventListener('DOMContentLoaded', function() {
            const checkbox = document.getElementById('show_promo_banner');
            const contentFields = document.getElementById('promoContentFields');
            if (!checkbox.checked) {
                contentFields.style.display = 'none';
            }
        });
    </script>
</div>
@endsection
