@extends('layouts.admin')

@section('title', 'Faturalar')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item"><a href="{{ route('admin.settings.membership') }}">Ayarlar</a></li>
    <li class="breadcrumb-item active">Faturalar</li>
@endsection

@section('content')
<style>
    .date-filter-input {
        max-width: 150px;
    }
    @media (max-width: 768px) {
        .date-filter-input {
            max-width: 100%;
            width: 100%;
            margin-bottom: 0.5rem;
        }
        .card-header .d-flex.flex-column.flex-md-row .d-flex.gap-2 {
            flex-direction: column;
            align-items: stretch !important;
            width: 100%;
        }
    }
    input[type="date"]::before {
        content: attr(placeholder);
        color: #999;
        width: 100%;
    }
    input[type="date"]:focus::before,
    input[type="date"]:valid::before {
        display: none;
    }
</style>
    <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-3 gap-2">
        <h2 class="mb-0"><i class="bi bi-receipt"></i> Faturalar</h2>
        <div class="d-flex align-items-center gap-2">
            <small class="text-muted">Toplam Tutar:</small>
            <strong class="text-primary" style="font-size: 1.1rem;">{{ number_format($totalAmount ?? 0, 2, ',', '.') }} ₺</strong>
        </div>
    </div>
    
    <div class="card shadow-sm" style="min-height: calc(100vh - 250px); display: flex; flex-direction: column;">
        <div class="card-header border-0" style="background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);">
            <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center gap-3">
                <h5 class="mb-0 text-white"><i class="bi bi-list-ul"></i> Tüm Faturalar</h5>
                <form method="GET" action="{{ route('admin.settings.invoices.index') }}" class="d-flex flex-column flex-md-row align-items-start align-items-md-center gap-2">
                    @foreach(request()->except('sort', 'page', 'date_from', 'date_to') as $key => $value)
                        <input type="hidden" name="{{ $key }}" value="{{ $value }}">
                    @endforeach
                    
                    <!-- Tarih Filtreleri -->
                    <div class="d-flex gap-2 align-items-center">
                        <label class="form-label mb-0 small text-white-50">Başlangıç:</label>
                        <input type="text" name="start_date" value="{{ request('start_date') }}" class="form-control form-control-sm date-filter-input" placeholder="gg.aa.yyyy" onfocus="this.type='date'; if(!this.value && this.placeholder) this.placeholder='';" onblur="if(!this.value) { this.type='text'; this.placeholder='gg.aa.yyyy'; }" style="width: auto; min-width: 150px; background: rgba(255,255,255,0.2); border: 1px solid rgba(255,255,255,0.3); color: white;" onchange="this.form.submit()">
                    </div>
                    <div class="d-flex gap-2 align-items-center">
                        <label class="form-label mb-0 small text-white-50">Bitiş:</label>
                        <input type="text" name="end_date" value="{{ request('end_date') }}" class="form-control form-control-sm date-filter-input" placeholder="gg.aa.yyyy" onfocus="this.type='date'; if(!this.value && this.placeholder) this.placeholder='';" onblur="if(!this.value) { this.type='text'; this.placeholder='gg.aa.yyyy'; }" style="width: auto; min-width: 150px; background: rgba(255,255,255,0.2); border: 1px solid rgba(255,255,255,0.3); color: white;" onchange="this.form.submit()">
                    </div>
                    
                    <!-- Sıralama -->
                    <div class="d-flex gap-2 align-items-center">
                        <label class="form-label mb-0 small text-white-50">Sırala:</label>
                        <select name="sort" class="form-select form-select-sm" style="width: auto; min-width: 150px; background: rgba(255,255,255,0.2); border: 1px solid rgba(255,255,255,0.3); color: white;" onchange="this.form.submit()">
                            <option value="name_asc" {{ request('sort') == 'name_asc' ? 'selected' : '' }} style="background: #2563eb; color: white;">A-Z (Müşteri)</option>
                            <option value="created_desc" {{ request('sort', 'created_desc') == 'created_desc' ? 'selected' : '' }} style="background: #2563eb; color: white;">Yeniden Eskiye</option>
                        </select>
                    </div>
                    
                    @if(request('start_date') || request('end_date'))
                        <a href="{{ route('admin.settings.invoices.index') }}" class="btn btn-sm btn-outline-light">
                            <i class="bi bi-x-circle"></i> Filtreleri Temizle
                        </a>
                    @endif
                </form>
            </div>
        </div>
        <div class="card-body p-0" style="flex: 1; display: flex; flex-direction: column; overflow: hidden;">
            <!-- Desktop Table -->
            <div class="table-responsive d-none d-md-block" style="flex: 1; overflow-y: auto;">
                <table class="table table-hover align-middle mb-0">
                    <thead class="table-light">
                        <tr>
                            <th>Fatura No</th>
                            <th>Rezervasyon</th>
                            <th>Müşteri</th>
                            <th>Tutar</th>
                            <th>Durum</th>
                            <th>Oluşturulma</th>
                            <th class="text-center" style="min-width: 200px;">İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($invoices as $invoice)
                            <tr>
                                <td>
                                    <strong class="text-primary">{{ $invoice->invoice_number }}</strong>
                                </td>
                                <td>
                                    @if($invoice->reservation)
                                        <span class="badge bg-light text-dark">
                                            {{ $invoice->reservation->date ? $invoice->reservation->date->format('d.m.Y') : '-' }}
                                        </span>
                                        <br>
                                        <small class="text-muted">{{ $invoice->reservation->salon->name ?? '-' }}</small>
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                                <td>
                                    <div class="d-flex align-items-center gap-2">
                                        @if($invoice->customer)
                                            <div class="rounded-circle d-flex align-items-center justify-content-center text-white fw-bold" 
                                                 style="width: 32px; height: 32px; font-size: 11px; background: {{ $invoice->customer->avatar_color ?? '#2563eb' }};">
                                                {{ $invoice->customer->initials ?? '??' }}
                                            </div>
                                            <div>
                                                <strong>{{ $invoice->customer->name ?? '-' }}</strong><br>
                                                <small class="text-muted">{{ $invoice->customer->phone ?? '-' }}</small>
                                            </div>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </div>
                                </td>
                                <td><strong>{{ number_format($invoice->total_amount, 2, ',', '.') }} ₺</strong></td>
                                <td>
                                    @if($invoice->status == 'sent')
                                        <span class="badge bg-info">
                                            <i class="bi bi-send"></i> Gönderildi
                                        </span>
                                    @elseif($invoice->status == 'paid')
                                        <span class="badge bg-success">
                                            <i class="bi bi-cash"></i> Ödendi
                                        </span>
                                    @elseif($invoice->status == 'cancelled')
                                        <span class="badge bg-danger">
                                            <i class="bi bi-x-circle"></i> İptal
                                        </span>
                                    @else
                                        <span class="badge bg-secondary">
                                            <i class="bi bi-file-text"></i> Fatura
                                        </span>
                                    @endif
                                </td>
                                <td>
                                    <small>{{ $invoice->created_at->format('d.m.Y H:i') }}</small>
                                    @if($invoice->creator)
                                        <br><small class="text-muted">{{ $invoice->creator->name ?? '' }}</small>
                                    @endif
                                </td>
                                <td class="text-center">
                                    <div class="btn-group btn-group-sm" role="group">
                                        <a href="{{ $invoice->public_url }}" target="_blank" class="btn btn-outline-primary" title="Görüntüle">
                                            <i class="bi bi-eye"></i>
                                        </a>
                                        <a href="{{ route('admin.invoices.download-pdf', $invoice->id) }}" class="btn btn-outline-danger" title="PDF İndir">
                                            <i class="bi bi-download"></i>
                                        </a>
                                        <button type="button" class="btn btn-outline-info sms-btn" data-invoice-id="{{ $invoice->id }}" onclick="sendInvoiceSms({{ $invoice->id }}, event)" title="SMS Gönder">
                                            <i class="bi bi-chat-dots"></i>
                                        </button>
                                        <button type="button" class="btn btn-outline-secondary" onclick="copyInvoiceLink('{{ $invoice->public_url }}')" title="Linki Kopyala">
                                            <i class="bi bi-link-45deg"></i>
                                        </button>
                                        <button type="button" class="btn btn-outline-danger" onclick="deleteInvoice({{ $invoice->id }})" title="Sil">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="text-center py-5">
                                    <i class="bi bi-receipt display-4 text-muted"></i>
                                    <p class="text-muted mt-2">Henüz fatura oluşturulmamış.</p>
                                    <p class="text-muted small">Rezervasyon oluştururken "Oluştur ve Faturala" butonuna tıklayarak fatura oluşturabilirsiniz.</p>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            
            <!-- Mobile Cards -->
            <div class="d-md-none" style="flex: 1; overflow-y: auto;">
                @forelse($invoices as $invoice)
                    <div class="card mb-3 mx-3 mt-3 border-start border-4" style="border-left-color: {{ $invoice->status == 'paid' ? '#10b981' : ($invoice->status == 'sent' ? '#3b82f6' : ($invoice->status == 'cancelled' ? '#ef4444' : '#6b7280')) }};">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-start mb-2">
                                <div>
                                    <h6 class="mb-1 text-primary fw-bold">{{ $invoice->invoice_number }}</h6>
                                    <small class="text-muted">{{ $invoice->created_at->format('d.m.Y H:i') }}</small>
                                </div>
                                <div>
                                    @if($invoice->status == 'sent')
                                        <span class="badge bg-info">
                                            <i class="bi bi-send"></i> Gönderildi
                                        </span>
                                    @elseif($invoice->status == 'paid')
                                        <span class="badge bg-success">
                                            <i class="bi bi-cash"></i> Ödendi
                                        </span>
                                    @elseif($invoice->status == 'cancelled')
                                        <span class="badge bg-danger">
                                            <i class="bi bi-x-circle"></i> İptal
                                        </span>
                                    @else
                                        <span class="badge bg-secondary">
                                            <i class="bi bi-file-text"></i> Fatura
                                        </span>
                                    @endif
                                </div>
                            </div>
                            
                            @if($invoice->customer)
                                <div class="d-flex align-items-center gap-2 mb-2">
                                    <div class="rounded-circle d-flex align-items-center justify-content-center text-white fw-bold" 
                                         style="width: 32px; height: 32px; font-size: 11px; background: {{ $invoice->customer->avatar_color ?? '#2563eb' }};">
                                        {{ $invoice->customer->initials ?? '??' }}
                                    </div>
                                    <div>
                                        <strong class="d-block">{{ $invoice->customer->name ?? '-' }}</strong>
                                        <small class="text-muted">{{ $invoice->customer->phone ?? '-' }}</small>
                                    </div>
                                </div>
                            @endif
                            
                            @if($invoice->reservation)
                                <div class="mb-2">
                                    <small class="text-muted d-block">Rezervasyon:</small>
                                    <span class="badge bg-light text-dark">
                                        {{ $invoice->reservation->date ? $invoice->reservation->date->format('d.m.Y') : '-' }}
                                    </span>
                                    <small class="text-muted ms-2">{{ $invoice->reservation->salon->name ?? '-' }}</small>
                                </div>
                            @endif
                            
                            <div class="row g-2 mb-2">
                                <div class="col-12">
                                    <small class="text-muted d-block">Tutar</small>
                                    <strong>{{ number_format($invoice->total_amount, 2, ',', '.') }} ₺</strong>
                                </div>
                            </div>
                            
                            <div class="d-flex flex-wrap gap-1 mt-2">
                                <a href="{{ $invoice->public_url }}" target="_blank" class="btn btn-sm btn-outline-primary flex-fill">
                                    <i class="bi bi-eye"></i> Görüntüle
                                </a>
                                <a href="{{ route('admin.invoices.download-pdf', $invoice->id) }}" class="btn btn-sm btn-outline-danger">
                                    <i class="bi bi-download"></i>
                                </a>
                                <button type="button" class="btn btn-sm btn-outline-info sms-btn" data-invoice-id="{{ $invoice->id }}" onclick="sendInvoiceSms({{ $invoice->id }}, event)">
                                    <i class="bi bi-chat-dots"></i>
                                </button>
                                <button type="button" class="btn btn-sm btn-outline-secondary" onclick="copyInvoiceLink('{{ $invoice->public_url }}')">
                                    <i class="bi bi-link-45deg"></i>
                                </button>
                                <button type="button" class="btn btn-sm btn-outline-danger" onclick="deleteInvoice({{ $invoice->id }})">
                                    <i class="bi bi-trash"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                @empty
                    <div class="text-center py-5 px-3">
                        <i class="bi bi-receipt display-4 text-muted"></i>
                        <p class="text-muted mt-2">Henüz fatura oluşturulmamış.</p>
                        <p class="text-muted small">Rezervasyon oluştururken "Oluştur ve Faturala" butonuna tıklayarak fatura oluşturabilirsiniz.</p>
                    </div>
                @endforelse
            </div>
            
            <div class="mt-auto px-3 pb-3 border-top" style="flex-shrink: 0;">
                {{ $invoices->links() }}
            </div>
        </div>
    </div>
@endsection

@section('scripts')
<style>
.sms-btn:disabled {
    opacity: 0.5;
    cursor: not-allowed !important;
}

.sms-btn[data-tooltip] {
    position: relative;
}

.sms-btn[data-tooltip]:hover::after {
    content: attr(data-tooltip);
    position: absolute;
    bottom: 100%;
    left: 50%;
    transform: translateX(-50%);
    background: rgba(0, 0, 0, 0.9);
    color: white;
    padding: 8px 12px;
    border-radius: 6px;
    font-size: 12px;
    white-space: nowrap;
    z-index: 1000;
    margin-bottom: 5px;
    pointer-events: none;
}

.sms-btn[data-tooltip]:hover::before {
    content: '';
    position: absolute;
    bottom: 100%;
    left: 50%;
    transform: translateX(-50%);
    border: 5px solid transparent;
    border-top-color: rgba(0, 0, 0, 0.9);
    z-index: 1000;
    margin-bottom: -5px;
    pointer-events: none;
}
</style>
<script>
// SMS Gönderme Kısıtlaması - 30 dakika
const SMS_COOLDOWN_MINUTES = 30;
const SMS_COOLDOWN_MS = SMS_COOLDOWN_MINUTES * 60 * 1000;

// Geri sayımı formatla
function formatCountdown(seconds) {
    const minutes = Math.floor(seconds / 60);
    const secs = seconds % 60;
    return `${minutes}:${secs.toString().padStart(2, '0')}`;
}

// SMS butonlarının durumunu kontrol et ve güncelle
function checkSmsButtonStatus() {
    document.querySelectorAll('.sms-btn').forEach(button => {
        const invoiceId = button.getAttribute('data-invoice-id');
        const lastSentTime = localStorage.getItem(`sms_sent_${invoiceId}`);
        
        if (lastSentTime) {
            const elapsed = Date.now() - parseInt(lastSentTime);
            const remaining = SMS_COOLDOWN_MS - elapsed;
            
            if (remaining > 0) {
                // Hala bekleme süresi var
                button.disabled = true;
                button.classList.add('disabled');
                
                // Geri sayım hesapla
                const remainingSeconds = Math.ceil(remaining / 1000);
                const countdown = formatCountdown(remainingSeconds);
                button.setAttribute('data-tooltip', `Tekrar kullanmak için ${countdown} bekleyin`);
            } else {
                // Bekleme süresi doldu
                button.disabled = false;
                button.classList.remove('disabled');
                button.removeAttribute('data-tooltip');
                button.title = 'SMS Gönder';
                localStorage.removeItem(`sms_sent_${invoiceId}`);
            }
        } else {
            // Hiç SMS gönderilmemiş veya süre dolmuş
            button.disabled = false;
            button.classList.remove('disabled');
            button.removeAttribute('data-tooltip');
            button.title = 'SMS Gönder';
        }
    });
}

// Her saniye geri sayımı güncelle
setInterval(checkSmsButtonStatus, 1000);

// Sayfa yüklendiğinde kontrol et
document.addEventListener('DOMContentLoaded', function() {
    checkSmsButtonStatus();
    
    // Hover durumunda geri sayımı güncelle
    document.querySelectorAll('.sms-btn').forEach(button => {
        button.addEventListener('mouseenter', function() {
            if (this.disabled) {
                const invoiceId = this.getAttribute('data-invoice-id');
                const lastSentTime = localStorage.getItem(`sms_sent_${invoiceId}`);
                
                if (lastSentTime) {
                    const elapsed = Date.now() - parseInt(lastSentTime);
                    const remaining = SMS_COOLDOWN_MS - elapsed;
                    
                    if (remaining > 0) {
                        const remainingSeconds = Math.ceil(remaining / 1000);
                        const countdown = formatCountdown(remainingSeconds);
                        this.setAttribute('data-tooltip', `Tekrar kullanmak için ${countdown} bekleyin`);
                    }
                }
            }
        });
        
        // Mouse move ile geri sayımı sürekli güncelle
        button.addEventListener('mousemove', function() {
            if (this.disabled) {
                const invoiceId = this.getAttribute('data-invoice-id');
                const lastSentTime = localStorage.getItem(`sms_sent_${invoiceId}`);
                
                if (lastSentTime) {
                    const elapsed = Date.now() - parseInt(lastSentTime);
                    const remaining = SMS_COOLDOWN_MS - elapsed;
                    
                    if (remaining > 0) {
                        const remainingSeconds = Math.ceil(remaining / 1000);
                        const countdown = formatCountdown(remainingSeconds);
                        this.setAttribute('data-tooltip', `Tekrar kullanmak için ${countdown} bekleyin`);
                    }
                }
            }
        });
    });
});

// SMS Gönder
async function sendInvoiceSms(id, event) {
    // Kısıtlama kontrolü
    const lastSentTime = localStorage.getItem(`sms_sent_${id}`);
    if (lastSentTime) {
        const elapsed = Date.now() - parseInt(lastSentTime);
        if (elapsed < SMS_COOLDOWN_MS) {
            const remaining = SMS_COOLDOWN_MS - elapsed;
            const remainingSeconds = Math.ceil(remaining / 1000);
            const countdown = formatCountdown(remainingSeconds);
            showToast('error', `SMS göndermek için ${countdown} beklemelisiniz.`);
            return;
        }
    }
    
    const confirmed = await customConfirm('Bu faturayı SMS ile müşteriye göndermek istediğinize emin misiniz?');
    if (!confirmed) return;
    
    // Butonu geçici olarak disable et (tekrar tıklamayı önle)
    let button = null;
    let originalHTML = '';
    if (event && event.target) {
        button = event.target.closest('button');
        if (button) {
            button.disabled = true;
            originalHTML = button.innerHTML;
            button.innerHTML = '<span class="spinner-border spinner-border-sm"></span>';
        }
    }
    
    fetch(`{{ url('/admin/ayarlar/faturalar') }}/${id}/sms`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '{{ csrf_token() }}',
            'Accept': 'application/json'
        }
    })
    .then(response => response.json().catch(() => ({})))
    .then(data => {
        if (data.success) {
            // SMS gönderme zamanını kaydet
            localStorage.setItem(`sms_sent_${id}`, Date.now().toString());
            
            showToast('success', 'SMS başarıyla gönderildi.');
            if (data.remaining_balance !== null) {
                showToast('info', 'Kalan SMS bakiyeniz: ' + data.remaining_balance);
            }
            
            // Buton durumunu güncelle
            if (button) {
                button.disabled = true;
                button.classList.add('disabled');
                button.innerHTML = originalHTML;
                checkSmsButtonStatus();
            }
            
            // Sayfayı yenileme - sadece buton durumunu güncelle
            // window.location.reload();
        } else {
            showToast('error', data.message || 'SMS gönderilemedi.');
            // SMS bakiyesi yetersizse yönlendir
            if (data.redirect) {
                setTimeout(() => {
                    window.location.href = data.redirect;
                }, 1500);
            }
            // Butonu tekrar aktif et
            if (button) {
                button.disabled = false;
                button.innerHTML = originalHTML;
            }
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showToast('error', 'Bir hata oluştu.');
        // Butonu tekrar aktif et
        if (button) {
            button.disabled = false;
            button.innerHTML = originalHTML;
        }
    });
}

// WhatsApp Gönder fonksiyonu kaldırıldı

// Link Kopyala
function copyInvoiceLink(url) {
    navigator.clipboard.writeText(url).then(() => {
        showToast('success', 'Fatura linki panoya kopyalandı.');
    }).catch(() => {
        // Fallback
        const input = document.createElement('input');
        input.value = url;
        document.body.appendChild(input);
        input.select();
        document.execCommand('copy');
        document.body.removeChild(input);
        showToast('success', 'Fatura linki panoya kopyalandı.');
    });
}

// Fatura Sil
async function deleteInvoice(id) {
    const confirmed = await customConfirm('Bu faturayı silmek istediğinize emin misiniz?\n\nBu işlem geri alınamaz!');
    if (!confirmed) return;
    
    // Onay verildikten sonra silme işlemini başlat
    fetch(`{{ url('/admin/faturalar') }}/${id}`, {
        method: 'DELETE',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '{{ csrf_token() }}',
            'Accept': 'application/json'
        }
    })
    .then(response => {
        // Response geldi mi kontrol et, her durumda sayfayı yenile
        return response.json().catch(() => ({}));
    })
    .then(data => {
        if (data && data.success) {
            showToast('success', 'Fatura başarıyla silindi.');
        } else {
            showToast('success', 'Fatura silindi.');
        }
        // Her durumda sayfayı yenile
        window.location.reload();
    })
    .catch(error => {
        console.error('Error:', error);
        // Hata olsa bile sayfayı yenile
        window.location.reload();
    });
}

// Toast Göster (varsa global fonksiyonu kullan, yoksa alert)
// Toast Göster - Global showToast kullan (popup olarak)
function showToast(type, message) {
    if (typeof window.showToast === 'function') {
        window.showToast(type, message);
    } else if (typeof showPopup === 'function') {
        showPopup(type, message);
    } else {
        alert(message);
    }
}
</script>
@endsection
