@extends('layouts.admin')

@section('title', 'Üyelik Bilgilerim')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item active">Üyelik Bilgilerim</li>
@endsection

@section('content')
<style>
    .membership-hero {
        background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%);
        border-radius: 20px;
        padding: 40px;
        color: white;
        margin-bottom: 30px;
        box-shadow: 0 10px 30px rgba(124, 58, 237, 0.3);
    }
    
    .membership-hero h1 {
        font-size: 36px;
        font-weight: 700;
        margin-bottom: 10px;
    }
    
    .membership-card {
        background: white;
        border-radius: 20px;
        padding: 32px;
        box-shadow: 0 4px 20px rgba(0,0,0,0.08);
        margin-bottom: 24px;
        border-left: 5px solid #2563eb;
    }
    
    .membership-info-item {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 20px;
        background: linear-gradient(135deg, #f8fafc 0%, #ffffff 100%);
        border-radius: 16px;
        margin-bottom: 16px;
        border: 2px solid #e2e8f0;
        transition: all 0.3s ease;
    }
    
    .membership-info-item:hover {
        border-color: #2563eb;
        box-shadow: 0 4px 12px rgba(124, 58, 237, 0.1);
        transform: translateY(-2px);
    }
    
    .membership-info-label {
        font-weight: 600;
        color: #475569;
        font-size: 15px;
        display: flex;
        align-items: center;
        gap: 10px;
    }
    
    .membership-info-label i {
        font-size: 20px;
        color: #2563eb;
    }
    
    .membership-info-value {
        font-weight: 700;
        color: #1e293b;
        font-size: 18px;
    }
    
    .badge-unlimited {
        background: linear-gradient(135deg, #10b981 0%, #059669 100%);
        color: white;
        padding: 8px 16px;
        border-radius: 12px;
        font-weight: 600;
        font-size: 14px;
    }
    
    .badge-expired {
        background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
        color: white;
        padding: 8px 16px;
        border-radius: 12px;
        font-weight: 600;
        font-size: 14px;
    }
    
    .badge-warning {
        background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);
        color: white;
        padding: 8px 16px;
        border-radius: 12px;
        font-weight: 600;
        font-size: 14px;
    }
    
    .badge-success {
        background: linear-gradient(135deg, #10b981 0%, #059669 100%);
        color: white;
        padding: 8px 16px;
        border-radius: 12px;
        font-weight: 600;
        font-size: 14px;
    }
</style>

<div class="container-fluid">
    <!-- Hero Section -->
    <div class="membership-hero">
        <h1><i class="bi bi-person-badge me-3"></i>Üyelik Bilgilerim</h1>
        <p>Lisans ve üyelik durumunuz</p>
    </div>
    
    <!-- SMS Bakiyesi Kutusu -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="membership-card" style="border-left-color: #10b981; background: linear-gradient(135deg, #ffffff 0%, #f0fdf4 100%);">
                <div class="d-flex align-items-center justify-content-between">
                    <div class="d-flex align-items-center gap-3">
                        <div style="width: 60px; height: 60px; border-radius: 16px; background: linear-gradient(135deg, #10b981 0%, #059669 100%); display: flex; align-items: center; justify-content: center; color: white; font-size: 28px; box-shadow: 0 4px 12px rgba(16, 185, 129, 0.3);">
                            <i class="bi bi-chat-dots"></i>
                        </div>
                        <div>
                            <h5 class="mb-1" style="color: #1e293b; font-weight: 700; font-size: 18px;">
                                SMS Bakiyesi
                            </h5>
                            <p class="mb-0 text-muted" style="font-size: 14px;">
                                Süper admin tarafından atanan SMS bakiyesi
                            </p>
                        </div>
                    </div>
                    <div class="text-end">
                        <div style="font-size: 42px; font-weight: 700; color: #10b981; line-height: 1;">
                            {{ number_format(auth()->user()->sms_balance ?? 0, 0) }}
                        </div>
                        <div style="font-size: 14px; color: #64748b; font-weight: 500; margin-top: 4px;">
                            SMS Kredisi
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="row">
        <div class="col-lg-8">
            <div class="membership-card">
                <h3 class="mb-4" style="color: #1e293b; font-weight: 700;">
                    <i class="bi bi-info-circle me-2" style="color: #7c3aed;"></i>Lisans Bilgileri
                </h3>
                
                <div class="membership-info-item">
                    <div class="membership-info-label">
                        <i class="bi bi-shield-check"></i>
                        <span>Lisans Durumu</span>
                    </div>
                    <div class="membership-info-value">
                        @if($isUnlimited)
                            <span class="badge-unlimited">
                                <i class="bi bi-infinity me-1"></i>Sınırsız
                            </span>
                        @elseif($licenseExpiresAt)
                            @php
                                $now = \Carbon\Carbon::now();
                                $expires = \Carbon\Carbon::parse($licenseExpiresAt);
                                $isExpired = $now->gt($expires);
                                $daysRemaining = $now->diffInDays($expires, false);
                            @endphp
                            @if($isExpired)
                                <span class="badge-expired">
                                    <i class="bi bi-x-circle me-1"></i>Süresi Dolmuş
                                </span>
                            @elseif($daysRemaining <= 7)
                                <span class="badge-warning">
                                    <i class="bi bi-exclamation-triangle me-1"></i>Yakında Dolacak
                                </span>
                            @else
                                <span class="badge-success">
                                    <i class="bi bi-check-circle me-1"></i>Aktif
                                </span>
                            @endif
                        @else
                            <span class="badge-unlimited">
                                <i class="bi bi-infinity me-1"></i>Sınırsız
                            </span>
                        @endif
                    </div>
                </div>
                
                <div class="membership-info-item">
                    <div class="membership-info-label">
                        <i class="bi bi-calendar-event"></i>
                        <span>Üyelik Bitiş Tarihi</span>
                    </div>
                    <div class="membership-info-value">
                        @if($isUnlimited)
                            <span style="color: #10b981; font-weight: 700;">Sınırsız</span>
                        @elseif($licenseExpiresAt)
                            <span>{{ \Carbon\Carbon::parse($licenseExpiresAt)->format('d.m.Y H:i') }}</span>
                        @else
                            <span style="color: #10b981; font-weight: 700;">Sınırsız</span>
                        @endif
                    </div>
                </div>
                
                <div class="membership-info-item">
                    <div class="membership-info-label">
                        <i class="bi bi-clock-history"></i>
                        <span>Kalan Süre</span>
                    </div>
                    <div class="membership-info-value">
                        @if($isUnlimited)
                            <span style="color: #10b981; font-weight: 700;">Sınırsız</span>
                        @elseif($licenseExpiresAt)
                            @php
                                $now = \Carbon\Carbon::now();
                                $expires = \Carbon\Carbon::parse($licenseExpiresAt);
                                $daysRemaining = $now->diffInDays($expires, false);
                            @endphp
                            @if($daysRemaining < 0)
                                <span style="color: #ef4444; font-weight: 700;">
                                    {{ abs($daysRemaining) }} gün önce doldu
                                </span>
                            @elseif($daysRemaining == 0)
                                <span style="color: #f59e0b; font-weight: 700;">Bugün doluyor</span>
                            @else
                                <span style="color: #10b981; font-weight: 700;">
                                    {{ $daysRemaining }} gün kaldı
                                </span>
                            @endif
                        @else
                            <span style="color: #10b981; font-weight: 700;">Sınırsız</span>
                        @endif
                    </div>
                </div>
                
                <div class="membership-info-item">
                    <div class="membership-info-label">
                        <i class="bi bi-person"></i>
                        <span>Kullanıcı Adı</span>
                    </div>
                    <div class="membership-info-value">
                        {{ auth()->user()->name }}
                    </div>
                </div>
                
                <div class="membership-info-item">
                    <div class="membership-info-label">
                        <i class="bi bi-envelope"></i>
                        <span>E-posta</span>
                    </div>
                    <div class="membership-info-value">
                        {{ auth()->user()->email }}
                    </div>
                </div>
                
                <div class="membership-info-item">
                    <div class="membership-info-label">
                        <i class="bi bi-telephone"></i>
                        <span>Telefon Numarası</span>
                    </div>
                    <div class="membership-info-value">
                        {{ auth()->user()->phone }}
                    </div>
                </div>
                
                <div class="membership-info-item">
                    <div class="membership-info-label">
                        <i class="bi bi-shield"></i>
                        <span>Rol</span>
                    </div>
                    <div class="membership-info-value">
                        @if(auth()->user()->role === 'super_admin')
                            <span class="badge bg-danger">Süper Admin</span>
                        @elseif(auth()->user()->role === 'admin')
                            <span class="badge bg-info">Rezervasyoncu</span>
                        @else
                            <span class="badge bg-info">Rezervasyoncu</span>
                        @endif
                    </div>
                </div>
            </div>
                </div>
                
        <div class="col-lg-4">
            <div class="membership-card" style="border-left-color: #10b981;">
                <h5 class="mb-3" style="color: #1e293b; font-weight: 700;">
                    <i class="bi bi-info-circle me-2" style="color: #10b981;"></i>Bilgilendirme
                </h5>
                <div class="alert alert-info mb-0" style="border-radius: 12px; border: none; background: linear-gradient(135deg, #eff6ff 0%, #dbeafe 100%);">
                    <i class="bi bi-lightbulb me-2"></i>
                    <strong>Lisans Süresi:</strong>
                    <p class="mb-0 mt-2" style="font-size: 14px;">
                        @if($isUnlimited)
                            Üyeliğiniz sınırsızdır. Süper admin tarafından atanan süreye göre otomatik olarak güncellenir.
                        @elseif($licenseExpiresAt)
                            Üyeliğiniz süper admin tarafından atanan süreye göre belirlenmiştir. 
                            @if($daysRemaining !== null && $daysRemaining < 0)
                                <strong class="text-danger">Lisans süreniz dolmuştur.</strong>
                            @elseif($daysRemaining !== null && $daysRemaining <= 7)
                                <strong class="text-warning">Lisans süreniz yakında dolacaktır.</strong>
                            @endif
                        @else
                            Üyeliğiniz sınırsızdır.
                        @endif
                    </p>
                </div>
            </div>
        </div>
        </div>
    </div>
@endsection
