@extends('layouts.admin')

@section('title', 'Menü Yönetimi')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item active">Sözleşmeler / Menüler</li>
@endsection

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2>Menü Yönetimi</h2>
        <a href="{{ route('admin.settings.menus.create') }}" class="btn btn-primary">
            <i class="bi bi-plus-circle"></i> Yeni Menü Ekle
        </a>
    </div>
    
    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0"><i class="bi bi-menu-button-wide"></i> Menüler</h5>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Menü Adı</th>
                            <th>Açıklama</th>
                            <th>Fiyat</th>
                            <th>Durum</th>
                            <th>İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($menus as $menu)
                            <tr>
                                <td><strong>{{ $menu->name }}</strong></td>
                                <td>{{ Str::limit($menu->description, 50) }}</td>
                                <td><strong class="text-success">{{ number_format($menu->price, 2) }} ₺</strong></td>
                                <td>
                                    @if($menu->is_active)
                                        <span class="badge bg-success">Aktif</span>
                                    @else
                                        <span class="badge bg-secondary">Pasif</span>
                                    @endif
                                </td>
                                <td>
                                    <a href="{{ route('admin.settings.menus.edit', $menu->id) }}" class="btn btn-sm btn-warning">
                                        <i class="bi bi-pencil"></i>
                                    </a>
                                    <form action="{{ route('admin.settings.menus.destroy', $menu->id) }}" method="POST" class="d-inline delete-form" data-message="Bu menüyü silmek istediğinize emin misiniz?">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-danger">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </form>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="text-center">Menü bulunamadı.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection

