@extends('layouts.admin')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2 class="fw-bold text-primary">
            <i class="bi bi-gear"></i> İşlemler
        </h2>
        <a href="{{ route('admin.settings.processes.create') }}" class="btn btn-primary">
            <i class="bi bi-plus-circle"></i> Yeni İşlem Ekle
        </a>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="card shadow-sm">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead class="table-light">
                        <tr>
                            <th>Sıra</th>
                            <th>İşlem Adı</th>
                            <th>Açıklama</th>
                            <th>İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($processes as $process)
                            <tr>
                                <td>{{ $process->order ?? '-' }}</td>
                                <td><strong>{{ $process->name }}</strong></td>
                                <td>{{ $process->description ?? '-' }}</td>
                                <td>
                                    <a href="{{ route('admin.settings.processes.edit', $process->id) }}" class="btn btn-sm btn-primary">
                                        <i class="bi bi-pencil"></i> Düzenle
                                    </a>
                                    <form action="{{ route('admin.settings.processes.destroy', $process->id) }}" method="POST" class="d-inline delete-form" data-message="Bu işlemi silmek istediğinizden emin misiniz?">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-danger">
                                            <i class="bi bi-trash"></i> Sil
                                        </button>
                                    </form>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="4" class="text-center text-muted py-4">
                                    <i class="bi bi-inbox"></i> Henüz işlem eklenmemiş.
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection

