@extends('layouts.admin')

@section('title', 'Rezervasyon Form Ayarları')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item active">Rezervasyon Form Ayarları</li>
@endsection

@section('content')
    <h2 class="mb-4">Rezervasyon Form Ayarları</h2>
    
    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0"><i class="bi bi-file-earmark-text"></i> Form Ayarları</h5>
        </div>
        <div class="card-body">
            <form method="POST" action="{{ route('admin.settings.reservation-form') }}">
                @csrf
                
                <div class="mb-3">
                    <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" name="require_phone" id="require_phone" value="1" {{ ($settings['require_phone'] ?? true) ? 'checked' : '' }}>
                        <label class="form-check-label fw-bold" for="require_phone">
                            Telefon Zorunlu
                        </label>
                    </div>
                </div>
                
                <div class="mb-3">
                    <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" name="require_email" id="require_email" value="1" {{ ($settings['require_email'] ?? false) ? 'checked' : '' }}>
                        <label class="form-check-label fw-bold" for="require_email">
                            E-posta Zorunlu
                        </label>
                    </div>
                </div>
                
                <div class="mb-3">
                    <label class="form-label fw-bold">Minimum Rezervasyon Süresi (Saat)</label>
                    <input type="number" name="min_reservation_hours" class="form-control form-control-lg" value="{{ $settings['min_reservation_hours'] ?? 2 }}" min="1">
                </div>
                
                <div class="mb-3">
                    <label class="form-label fw-bold">Maksimum İleri Tarih (Gün)</label>
                    <input type="number" name="max_advance_days" class="form-control form-control-lg" value="{{ $settings['max_advance_days'] ?? 365 }}" min="1">
                </div>
                
                <button type="submit" class="btn btn-lg btn-primary">
                    <i class="bi bi-check-circle"></i> Kaydet
                </button>
            </form>
        </div>
    </div>
@endsection

