@extends('layouts.admin')

@section('title', 'Yeni Salon Ekle')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item"><a href="{{ route('admin.settings.salons.index') }}">Salon Yönetimi</a></li>
    <li class="breadcrumb-item active">Yeni Salon</li>
@endsection

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2>Yeni Salon Ekle</h2>
        <a href="{{ route('admin.settings.salons.index') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> Geri
        </a>
    </div>
    
    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0"><i class="bi bi-building"></i> Salon Bilgileri</h5>
        </div>
        <div class="card-body">
            <form method="POST" action="{{ route('admin.settings.salons.store') }}">
                @csrf
                
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label class="form-label fw-bold">Salon Adı <span class="text-danger">*</span></label>
                        <input type="text" name="name" class="form-control form-control-lg" value="{{ old('name') }}" required>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label fw-bold">Telefon Numarası <span class="text-danger">*</span></label>
                        <input type="text" name="phone" class="form-control form-control-lg" value="{{ old('phone') }}" placeholder="05XX XXX XX XX" required>
                    </div>
                </div>
                
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label class="form-label fw-bold">Salon Kapasitesi <span class="text-danger">*</span></label>
                        <input type="number" name="capacity" class="form-control form-control-lg" value="{{ old('capacity') }}" min="1" placeholder="Kişi sayısı" required>
                    </div>
                </div>
                
                <div class="mb-3">
                    <label class="form-label fw-bold">Açıklama <span class="text-danger">*</span></label>
                    <textarea name="description" class="form-control" rows="4" required>{{ old('description') }}</textarea>
                </div>
                
                <div class="mb-3">
                    <label class="form-label fw-bold">Adres <span class="text-danger">*</span></label>
                    <textarea name="address" class="form-control" rows="2" placeholder="Salon adresi" required>{{ old('address') }}</textarea>
                </div>
                
                <div class="mb-3">
                    <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" name="is_active" id="is_active" value="1" {{ old('is_active', true) ? 'checked' : '' }}>
                        <label class="form-check-label fw-bold" for="is_active">
                            Aktif
                        </label>
                    </div>
                </div>
                
                <div class="d-flex justify-content-end gap-2">
                    <a href="{{ route('admin.settings.salons.index') }}" class="btn btn-lg btn-secondary">
                        <i class="bi bi-x-circle"></i> İptal
                    </a>
                    <button type="submit" class="btn btn-lg btn-primary">
                        <i class="bi bi-check-circle"></i> Kaydet
                    </button>
                </div>
            </form>
        </div>
    </div>
@endsection

