@extends('layouts.admin')

@section('title', 'Salon Düzenle')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item"><a href="{{ route('admin.settings.salons.index') }}">Salon Yönetimi</a></li>
    <li class="breadcrumb-item active">Düzenle</li>
@endsection

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2>Salon Düzenle</h2>
        <a href="{{ route('admin.settings.salons.index') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> Geri
        </a>
    </div>
    
    <div class="card shadow-sm">
        <div class="card-header" style="background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%);">
            <h5 class="mb-0 text-white"><i class="bi bi-pencil-square"></i> Salon Bilgileri</h5>
        </div>
        <div class="card-body">
            <form method="POST" action="{{ route('admin.settings.salons.update', $salon->id) }}">
                @csrf
                @method('PUT')
                
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label class="form-label fw-bold">Salon Adı <span class="text-danger">*</span></label>
                        <input type="text" name="name" class="form-control form-control-lg" value="{{ old('name', $salon->name) }}" required>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label fw-bold">Telefon Numarası <span class="text-danger">*</span></label>
                        <input type="text" name="phone" class="form-control form-control-lg" value="{{ old('phone', $salon->phone) }}" placeholder="05XX XXX XX XX" required>
                    </div>
                </div>
                
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label class="form-label fw-bold">Salon Kapasitesi <span class="text-danger">*</span></label>
                        <input type="number" name="capacity" class="form-control form-control-lg" value="{{ old('capacity', $salon->capacity) }}" min="1" placeholder="Kişi sayısı" required>
                    </div>
                </div>
                
                <div class="mb-3">
                    <label class="form-label fw-bold">Adres <span class="text-danger">*</span></label>
                    <textarea name="address" class="form-control" rows="2" placeholder="Salon adresi" required>{{ old('address', $salon->address) }}</textarea>
                </div>
                
                <div class="mb-3">
                    <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" name="is_active" id="is_active" value="1" {{ old('is_active', $salon->is_active) ? 'checked' : '' }}>
                        <label class="form-check-label fw-bold" for="is_active">
                            Aktif
                        </label>
                    </div>
                </div>
                
                <div class="d-flex justify-content-end gap-2">
                    <a href="{{ route('admin.settings.salons.index') }}" class="btn btn-lg btn-secondary">
                        <i class="bi bi-x-circle"></i> İptal
                    </a>
                    <button type="submit" class="btn btn-lg btn-primary">
                        <i class="bi bi-check-circle"></i> Güncelle
                    </button>
                </div>
            </form>
        </div>
    </div>
@endsection

