@extends('layouts.admin')

@section('title', 'Salon Yönetimi')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item active">Salonlar</li>
@endsection

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2 style="color: #2563eb;">
            <i class="bi bi-building"></i> Salon Bilgileri
        </h2>
        <a href="{{ route('admin.settings.salons.edit', $salon->id) }}" class="btn btn-warning">
            <i class="bi bi-pencil"></i> Düzenle
        </a>
    </div>
    
    <div class="row">
        <div class="col-md-8">
            <div class="card shadow-sm">
                <div class="card-header" style="background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%); color: white;">
                    <h5 class="mb-0 text-white"><i class="bi bi-building"></i> {{ $salon->name }}</h5>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <div class="d-flex align-items-center gap-2 mb-3">
                                <i class="bi bi-telephone text-primary" style="font-size: 1.2rem;"></i>
                                <div>
                                    <small class="text-muted d-block">Telefon</small>
                                    <strong>{{ $salon->phone ?? '-' }}</strong>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex align-items-center gap-2 mb-3">
                                <i class="bi bi-people text-primary" style="font-size: 1.2rem;"></i>
                                <div>
                                    <small class="text-muted d-block">Kapasite</small>
                                    <strong>{{ $salon->capacity ?? '-' }} kişi</strong>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="d-flex align-items-start gap-2 mb-3">
                                <i class="bi bi-geo-alt text-primary" style="font-size: 1.2rem; margin-top: 2px;"></i>
                                <div>
                                    <small class="text-muted d-block">Adres</small>
                                    <strong>{{ $salon->address ?? '-' }}</strong>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="d-flex align-items-center gap-2">
                                <span class="badge {{ $salon->is_active ? 'bg-success' : 'bg-secondary' }}" style="font-size: 0.9rem;">
                                    {{ $salon->is_active ? 'Aktif' : 'Pasif' }}
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection

@push('scripts')
<script>
// Salon yönetim scriptleri kaldırıldı - sadece düzenleme yapılabilir
</script>
@endpush

