@extends('layouts.admin')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2 class="fw-bold text-primary">
            <i class="bi bi-tools"></i> Servisler
        </h2>
        <a href="{{ route('admin.settings.services.create') }}" class="btn btn-primary">
            <i class="bi bi-plus-circle"></i> Yeni Servis Ekle
        </a>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="card shadow-sm">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead class="table-light">
                        <tr>
                            <th>Servis Adı</th>
                            <th>Açıklama</th>
                            <th>Fiyat</th>
                            <th>Durum</th>
                            <th>İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($services as $service)
                            <tr>
                                <td><strong>{{ $service->name }}</strong></td>
                                <td>{{ $service->description ?? '-' }}</td>
                                <td>{{ $service->price ? number_format($service->price, 2) . ' ₺' : '-' }}</td>
                                <td>
                                    @if($service->is_active)
                                        <span class="badge bg-success">Aktif</span>
                                    @else
                                        <span class="badge bg-secondary">Pasif</span>
                                    @endif
                                </td>
                                <td>
                                    <a href="{{ route('admin.settings.services.edit', $service->id) }}" class="btn btn-sm btn-primary">
                                        <i class="bi bi-pencil"></i> Düzenle
                                    </a>
                                    <form action="{{ route('admin.settings.services.destroy', $service->id) }}" method="POST" class="d-inline delete-form" data-message="Bu servisi silmek istediğinizden emin misiniz?">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-danger">
                                            <i class="bi bi-trash"></i> Sil
                                        </button>
                                    </form>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="text-center text-muted py-4">
                                    <i class="bi bi-inbox"></i> Henüz servis eklenmemiş.
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection

