@extends('layouts.admin')

@section('title', 'SMS Paketleri')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item active">SMS Paketleri</li>
@endsection

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2 class="fw-bold text-primary">
            <i class="bi bi-chat-dots"></i> SMS Paketleri
        </h2>
    </div>
    
    <div class="row g-4">
        @foreach($packages as $package)
        <div class="col-md-4">
            <div class="card shadow-sm h-100 border-0" style="border-radius: 15px; overflow: hidden; transition: all 0.3s;">
                <div class="card-body p-4" style="background: linear-gradient(135deg, #f8f9fa 0%, #ffffff 100%);">
                    <div class="text-center mb-4">
                        <div class="d-inline-flex align-items-center justify-content-center rounded-circle mb-3" style="width: 80px; height: 80px; background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%);">
                            <i class="bi bi-chat-dots-fill text-white" style="font-size: 36px;"></i>
                        </div>
                        <h4 class="fw-bold text-dark mb-2">{{ $package['name'] }}</h4>
                        <h2 class="text-primary fw-bold mb-1">{{ $package['price'] }}</h2>
                        <p class="text-muted mb-0">{{ $package['sms_count'] }}</p>
                    </div>
                    
                    <div class="text-center mt-4">
                        <a href="{{ $package['link'] }}" target="_blank" class="btn btn-primary btn-lg w-100" style="border-radius: 10px; font-weight: 600;">
                            <i class="bi bi-cart-plus me-2"></i> Satın Al
                        </a>
                    </div>
                </div>
            </div>
        </div>
        @endforeach
    </div>
    
    <div class="row mt-5">
        <div class="col-12">
            <div class="card shadow-sm border-0" style="border-radius: 15px;">
                <div class="card-body p-4">
                    <h5 class="fw-bold mb-3"><i class="bi bi-info-circle text-primary me-2"></i> SMS Paketleri Hakkında</h5>
                    <p class="text-muted mb-0">
                        SMS paketlerinizi satın aldıktan sonra, paket otomatik olarak hesabınıza yüklenecektir. 
                        SMS gönderimi için <a href="{{ route('admin.settings.sms') }}">SMS Ayarları</a> sayfasından API bilgilerinizi girmeniz gerekmektedir.
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

