@extends('layouts.admin')

@section('title', 'Ana Sözleşme Yönetimi')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.superadmin.dashboard') }}">Süper Admin</a></li>
    <li class="breadcrumb-item active">Ana Sözleşme</li>
@endsection

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2><i class="bi bi-file-earmark-text text-primary"></i> Ana Sözleşme Yönetimi</h2>
    </div>
    
    <div class="alert alert-warning mb-4">
        <i class="bi bi-exclamation-triangle"></i>
        <strong>Ana Sözleşme:</strong> Bu sözleşme <strong>sistem genelinde ana sözleşme</strong> olarak kullanılır. 
        Tüm rezervasyonlar, faturalar ve mesajlarda <strong>bu sözleşme önceliklidir</strong>. 
        Kullanıcıların kendi sözleşmeleri olsa bile, sistem önce bu ana sözleşmeyi kullanır.
        Değiştirdiğinizde <strong>anında tüm sistemde geçerli olur</strong>.
    </div>

    <div class="row">
        <div class="col-lg-8">
            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0">
                        <i class="bi bi-globe me-2"></i>
                        {{ $globalContract ? 'Ana Sözleşmeyi Düzenle' : 'Yeni Ana Sözleşme Oluştur' }}
                    </h5>
                </div>
                <div class="card-body">
                    <form method="POST" action="{{ route('admin.superadmin.global-contract.store') }}">
                        @csrf
                        
                        <div class="mb-3">
                            <label class="form-label fw-bold">Sözleşme Adı <span class="text-danger">*</span></label>
                            <input type="text" name="name" class="form-control form-control-lg" 
                                   value="{{ old('name', $globalContract->name ?? 'Ana Sözleşme') }}" required>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label fw-bold">Sözleşme İçeriği <span class="text-danger">*</span></label>
                            <textarea name="content" class="form-control" rows="20" required 
                                      style="font-family: monospace; font-size: 13px;">{{ old('content', $globalContract->content ?? '') }}</textarea>
                            <small class="text-muted">Her maddeyi yeni satırda yazın. Sistem otomatik olarak formatlar.</small>
                        </div>
                        
                        <div class="d-flex justify-content-between">
                            @if($globalContract)
                                <button type="button" class="btn btn-danger" onclick="confirmDelete()">
                                    <i class="bi bi-trash me-2"></i>Sözleşmeyi Sil
                                </button>
                            @else
                                <div></div>
                            @endif
                            
                            <button type="submit" class="btn btn-lg btn-success">
                                <i class="bi bi-check-circle me-2"></i>
                                {{ $globalContract ? 'Güncelle ve Herkese Uygula' : 'Oluştur ve Herkese Uygula' }}
                            </button>
                        </div>
                    </form>
                    
                    @if($globalContract)
                        <form id="deleteForm" method="POST" action="{{ route('admin.superadmin.global-contract.destroy') }}" class="d-none">
                            @csrf
                            @method('DELETE')
                        </form>
                    @endif
                </div>
            </div>
        </div>
        
        <div class="col-lg-4">
            @if($globalContract)
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-success text-white">
                        <h6 class="mb-0"><i class="bi bi-check-circle me-2"></i>Mevcut Ana Sözleşme</h6>
                    </div>
                    <div class="card-body">
                        <p><strong>Adı:</strong> {{ $globalContract->name }}</p>
                        <p><strong>Oluşturulma:</strong> {{ $globalContract->created_at->format('d.m.Y H:i') }}</p>
                        <p><strong>Son Güncelleme:</strong> {{ $globalContract->updated_at->format('d.m.Y H:i') }}</p>
                        
                        @if($globalContract->public_token)
                            <hr>
                            <p class="mb-2"><strong>Public Link:</strong></p>
                            <div class="input-group input-group-sm">
                                <input type="text" class="form-control" value="{{ route('public.contract', $globalContract->public_token) }}" readonly id="publicLink">
                                <button class="btn btn-outline-secondary" type="button" onclick="copyLink()">
                                    <i class="bi bi-clipboard"></i>
                                </button>
                                <a href="{{ route('public.contract', $globalContract->public_token) }}" target="_blank" class="btn btn-outline-primary">
                                    <i class="bi bi-eye"></i>
                                </a>
                            </div>
                        @endif
                    </div>
                </div>
            @endif
            
            <div class="card shadow-sm">
                <div class="card-header bg-warning text-dark">
                    <h6 class="mb-0"><i class="bi bi-lightbulb me-2"></i>Nasıl Çalışır?</h6>
                </div>
                <div class="card-body">
                    <ul class="mb-0">
                        <li class="mb-2">Bu sözleşme <strong>sistem genelinde ana sözleşme</strong> olarak kullanılır.</li>
                        <li class="mb-2"><strong>Öncelikli sözleşme:</strong> Tüm rezervasyon ve faturalarda bu sözleşme kullanılır.</li>
                        <li class="mb-2">Güncellediğinizde <strong>anında tüm sistemde</strong> yeni sözleşme geçerli olur.</li>
                        <li class="mb-2">SMS ve WhatsApp mesajlarında bu sözleşme linki gönderilir.</li>
                        <li>Rezervasyon oluştururken bu ana sözleşme otomatik kullanılır.</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
<script>
function copyLink() {
    const input = document.getElementById('publicLink');
    input.select();
    document.execCommand('copy');
    
    const btn = input.nextElementSibling;
    const originalHtml = btn.innerHTML;
    btn.innerHTML = '<i class="bi bi-check"></i>';
    btn.classList.remove('btn-outline-secondary');
    btn.classList.add('btn-success');
    
    setTimeout(() => {
        btn.innerHTML = originalHtml;
        btn.classList.remove('btn-success');
        btn.classList.add('btn-outline-secondary');
    }, 1500);
}

function confirmDelete() {
    if (confirm('Bu ana sözleşmeyi silmek istediğinize emin misiniz?\n\nBu işlem geri alınamaz ve tüm sistem etkilenecektir!')) {
        document.getElementById('deleteForm').submit();
    }
}
</script>
@endpush
