<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\ReservationController;
use App\Http\Controllers\Admin\ReservationCalendarController;
use App\Http\Controllers\Admin\ReservationMessageController;
use App\Http\Controllers\Admin\ReservationOfferController;
use App\Http\Controllers\Admin\WidgetController;
use App\Http\Controllers\Admin\CampaignController;
use App\Http\Controllers\Admin\SettingsController;
use App\Http\Controllers\Admin\ContractController;
use App\Http\Controllers\Admin\MenuController;
use App\Http\Controllers\Admin\ExtraController;
use App\Http\Controllers\Admin\SalonController;
use App\Http\Controllers\Admin\ProcessController;
use App\Http\Controllers\Admin\ServiceController;
use App\Http\Controllers\Admin\AccountingController;
use App\Http\Controllers\Admin\CashboxController;
use App\Http\Controllers\Admin\CustomerAccountController;
use App\Http\Controllers\Admin\ReportController;
use App\Http\Controllers\Admin\ContactController;
use App\Http\Controllers\Admin\CompanyController;
use App\Http\Controllers\Admin\CustomerController;
use App\Http\Controllers\Admin\AppointmentController;
use App\Http\Controllers\Admin\AccountController;
use App\Http\Controllers\Admin\HelpController;
use App\Http\Controllers\Admin\InvoiceController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\DownloadController;
use App\Http\Controllers\PageController;
use App\Http\Controllers\SuperAdmin\SuperAdminController;
use App\Http\Controllers\Admin\SearchController;
use App\Http\Controllers\Auth\RegisterController;

// Ana Sayfa (Rate limiting ile - dakikada 60 istek)
Route::get('/', [HomeController::class, 'index'])->middleware('throttle:60,1')->name('home');

// Download Routes
Route::get('/indir/windows', [DownloadController::class, 'windows'])->name('download.windows');

// Sitemap
Route::get('/sitemap.xml', [\App\Http\Controllers\SitemapController::class, 'index'])->name('sitemap');

// Public Pages
Route::get('/hakkimizda', [PageController::class, 'about'])->name('pages.about');
Route::get('/iletisim', [PageController::class, 'contact'])->name('pages.contact');
Route::get('/fiyatlandirma', [PageController::class, 'pricing'])->name('pages.pricing');
Route::get('/kayit', [RegisterController::class, 'showRegistrationForm'])->name('pages.register');

// Yasal Sayfalar (SEO için önemli)
Route::get('/gizlilik-politikasi', [PageController::class, 'privacy'])->name('pages.privacy');
Route::get('/kullanim-sartlari', [PageController::class, 'terms'])->name('pages.terms');
Route::get('/kvkk', [PageController::class, 'kvkk'])->name('pages.kvkk');
Route::get('/cerez-politikasi', [PageController::class, 'cookies'])->name('pages.cookies');
Route::get('/sss', [PageController::class, 'faq'])->name('pages.faq');
Route::get('/ozellikler', [PageController::class, 'features'])->name('pages.features');

// Login Routes
Route::get('/login', [LoginController::class, 'showLoginForm'])->name('login');
Route::post('/login', [LoginController::class, 'login']);
Route::post('/logout', [LoginController::class, 'logout'])->name('logout');
// GET logout - direkt anasayfaya yönlendir
Route::get('/logout', function() {
    // Eğer kullanıcı giriş yapmışsa logout yap
    if (auth()->check()) {
        auth()->logout();
        request()->session()->invalidate();
        request()->session()->regenerateToken();
    }
    return redirect('/');
})->name('logout.get');

// Register Routes
Route::get('/register', [RegisterController::class, 'showRegistrationForm'])->name('register');
Route::post('/register/check-email', [RegisterController::class, 'checkEmail'])->name('register.check-email');
Route::post('/register/check-phone', [RegisterController::class, 'checkPhone'])->name('register.check-phone');
Route::post('/register/send-otp', [RegisterController::class, 'sendRegistrationOtp'])->name('register.send-otp');
Route::post('/register', [RegisterController::class, 'register']);

// Mobile API Routes (Flutter)
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\ReservationApiController;
use App\Http\Controllers\Api\CustomerApiController;
use App\Http\Controllers\Api\SalonApiController;
use App\Http\Controllers\Api\DashboardApiController;
use App\Http\Controllers\Api\InvoiceApiController;
use App\Http\Controllers\Api\ContractApiController;
use App\Http\Controllers\Api\CashboxApiController;
use App\Http\Controllers\Api\MenuApiController;
use App\Http\Controllers\Api\ExtraApiController;
use App\Http\Controllers\Api\ProcessApiController;
use App\Http\Controllers\Api\ServiceApiController;
use App\Http\Controllers\Api\AppointmentApiController;
use App\Http\Controllers\Api\ContactApiController;
use App\Http\Controllers\Api\CompanyApiController;
use App\Http\Controllers\Api\ReportApiController;
use App\Http\Controllers\Api\CampaignApiController;

Route::prefix('api/mobile')->name('api.mobile.')->group(function () {
    // Auth (public)
    Route::post('/login', [AuthController::class, 'login'])->name('login');
    
    // Protected routes (Sanctum veya session auth)
    Route::middleware('auth')->group(function () {
        Route::post('/logout', [AuthController::class, 'logout'])->name('logout');
        Route::get('/me', [AuthController::class, 'me'])->name('me');
        // Dashboard
        Route::get('/dashboard', [DashboardApiController::class, 'index'])->name('dashboard.index');
        
        // Reservations
        Route::get('/reservations', [ReservationApiController::class, 'index'])->name('reservations.index');
        Route::post('/reservations', [ReservationApiController::class, 'store'])->name('reservations.store');
        Route::get('/reservations/{id}', [ReservationApiController::class, 'show'])->name('reservations.show');
        Route::get('/reservations/check-times', [ReservationApiController::class, 'checkAvailableTimes'])->name('reservations.check-times');
        
        // Customers
        Route::get('/customers', [CustomerApiController::class, 'index'])->name('customers.index');
        Route::get('/customers/{id}', [CustomerApiController::class, 'show'])->name('customers.show');
        
        // Salons
        Route::get('/salons', [SalonApiController::class, 'index'])->name('salons.index');
        
        // Invoices
        Route::get('/invoices', [InvoiceApiController::class, 'index'])->name('invoices.index');
        Route::get('/invoices/{id}', [InvoiceApiController::class, 'show'])->name('invoices.show');
        
        // Contracts
        Route::get('/contracts', [ContractApiController::class, 'index'])->name('contracts.index');
        Route::get('/contracts/{id}', [ContractApiController::class, 'show'])->name('contracts.show');
        
        // Cashbox
        Route::get('/cashbox', [CashboxApiController::class, 'index'])->name('cashbox.index');
        Route::post('/cashbox/income', [CashboxApiController::class, 'storeIncome'])->name('cashbox.income.store');
        Route::post('/cashbox/expense', [CashboxApiController::class, 'storeExpense'])->name('cashbox.expense.store');
        
        // Menus
        Route::get('/menus', [MenuApiController::class, 'index'])->name('menus.index');
        Route::post('/menus', [MenuApiController::class, 'store'])->name('menus.store');
        Route::get('/menus/{id}', [MenuApiController::class, 'show'])->name('menus.show');
        Route::put('/menus/{id}', [MenuApiController::class, 'update'])->name('menus.update');
        Route::delete('/menus/{id}', [MenuApiController::class, 'destroy'])->name('menus.destroy');
        
        // Extras
        Route::get('/extras', [ExtraApiController::class, 'index'])->name('extras.index');
        Route::post('/extras', [ExtraApiController::class, 'store'])->name('extras.store');
        Route::get('/extras/{id}', [ExtraApiController::class, 'show'])->name('extras.show');
        Route::put('/extras/{id}', [ExtraApiController::class, 'update'])->name('extras.update');
        Route::delete('/extras/{id}', [ExtraApiController::class, 'destroy'])->name('extras.destroy');
        
        // Processes
        Route::get('/processes', [ProcessApiController::class, 'index'])->name('processes.index');
        Route::post('/processes', [ProcessApiController::class, 'store'])->name('processes.store');
        Route::get('/processes/{id}', [ProcessApiController::class, 'show'])->name('processes.show');
        Route::put('/processes/{id}', [ProcessApiController::class, 'update'])->name('processes.update');
        Route::delete('/processes/{id}', [ProcessApiController::class, 'destroy'])->name('processes.destroy');
        
        // Services
        Route::get('/services', [ServiceApiController::class, 'index'])->name('services.index');
        Route::post('/services', [ServiceApiController::class, 'store'])->name('services.store');
        Route::get('/services/{id}', [ServiceApiController::class, 'show'])->name('services.show');
        Route::put('/services/{id}', [ServiceApiController::class, 'update'])->name('services.update');
        Route::delete('/services/{id}', [ServiceApiController::class, 'destroy'])->name('services.destroy');
        
        // Appointments
        Route::get('/appointments', [AppointmentApiController::class, 'index'])->name('appointments.index');
        Route::post('/appointments', [AppointmentApiController::class, 'store'])->name('appointments.store');
        Route::get('/appointments/{id}', [AppointmentApiController::class, 'show'])->name('appointments.show');
        Route::put('/appointments/{id}', [AppointmentApiController::class, 'update'])->name('appointments.update');
        Route::delete('/appointments/{id}', [AppointmentApiController::class, 'destroy'])->name('appointments.destroy');
        
        // Contacts
        Route::get('/contacts', [ContactApiController::class, 'index'])->name('contacts.index');
        Route::post('/contacts', [ContactApiController::class, 'store'])->name('contacts.store');
        Route::get('/contacts/{id}', [ContactApiController::class, 'show'])->name('contacts.show');
        Route::put('/contacts/{id}', [ContactApiController::class, 'update'])->name('contacts.update');
        Route::delete('/contacts/{id}', [ContactApiController::class, 'destroy'])->name('contacts.destroy');
        
        // Companies
        Route::get('/companies', [CompanyApiController::class, 'index'])->name('companies.index');
        Route::post('/companies', [CompanyApiController::class, 'store'])->name('companies.store');
        Route::get('/companies/{id}', [CompanyApiController::class, 'show'])->name('companies.show');
        Route::put('/companies/{id}', [CompanyApiController::class, 'update'])->name('companies.update');
        Route::delete('/companies/{id}', [CompanyApiController::class, 'destroy'])->name('companies.destroy');
        
        // Reports
        Route::get('/reports/monthly-reservations', [ReportApiController::class, 'monthlyReservations'])->name('reports.monthly-reservations');
        Route::get('/reports/monthly-revenue', [ReportApiController::class, 'monthlyRevenue'])->name('reports.monthly-revenue');
        Route::get('/reports/weekly', [ReportApiController::class, 'weekly'])->name('reports.weekly');
        
        // Campaigns
        Route::get('/campaigns/sms-balance', [CampaignApiController::class, 'getSmsBalance'])->name('campaigns.sms-balance');
        Route::post('/campaigns/send-bulk-sms', [CampaignApiController::class, 'sendBulkSms'])->name('campaigns.send-bulk-sms');
        Route::post('/campaigns/generate-referral-code', [CampaignApiController::class, 'generateReferralCode'])->name('campaigns.generate-referral-code');
        Route::get('/campaigns/referral-stats', [CampaignApiController::class, 'getReferralStats'])->name('campaigns.referral-stats');
    });
});

// Admin Routes
Route::middleware(['auth', 'check.license'])->prefix('admin')->name('admin.')->group(function () {
    
    // Dashboard
    Route::get('/', [DashboardController::class, 'index'])->name('dashboard');
    
    // Rezervasyon İşlemleri
    Route::prefix('rezervasyon')->name('reservations.')->group(function () {
        Route::get('/takvim', [ReservationCalendarController::class, 'index'])->name('calendar');
        Route::get('/takvim-feed', [ReservationCalendarController::class, 'feed'])->name('calendar.feed');
        Route::get('/tum-yil-takvimi', [ReservationCalendarController::class, 'year'])->name('year-calendar');
        Route::get('/tum-yil-takvimi-v2', [ReservationCalendarController::class, 'yearV2'])->name('year-calendar-v2');
        Route::get('/mesajlar', [ReservationMessageController::class, 'index'])->name('messages');
        Route::get('/gunluk', [ReservationController::class, 'daily'])->name('daily');
        Route::get('/iptal', [ReservationController::class, 'cancelled'])->name('cancelled');
        Route::get('/acik', [ReservationController::class, 'open'])->name('open');
        Route::get('/teklifler', [ReservationOfferController::class, 'index'])->name('offers');
        Route::get('/site-takvim', [WidgetController::class, 'calendarEmbed'])->name('widget-calendar');
    });
    
    // Rezervasyon CRUD
    Route::resource('rezervasyonlar', ReservationController::class);
    Route::get('/rezervasyonlar/check-availability', [ReservationController::class, 'checkAvailability'])->name('reservations.check-availability');
    Route::post('/rezervasyonlar/check-times', [ReservationController::class, 'checkAvailableTimes'])->name('reservations.check-times');
    Route::post('/rezervasyonlar/{id}/onayla', [ReservationController::class, 'confirm'])->name('reservations.confirm');
    Route::post('/rezervasyonlar/{id}/tamamla', [ReservationController::class, 'complete'])->name('reservations.complete');
    Route::post('/rezervasyonlar/{id}/status', [ReservationController::class, 'updateStatus'])->name('reservations.update-status');
    Route::get('/fatura/{id}', [InvoiceController::class, 'show'])->name('invoices.show');
    Route::post('/fatura/kaydet', [InvoiceController::class, 'store'])->name('invoices.store');
    Route::post('/fatura/{id}/sms', [InvoiceController::class, 'sendSms'])->name('invoices.send-sms');
    Route::get('/sozlesme/rezervasyon/{reservationId}', [ContractController::class, 'showForReservation'])->name('contracts.show-reservation');
    
    // Kampanyalar
    Route::prefix('kampanyalar')->name('campaigns.')->group(function () {
        Route::get('/sms-kazan', [CampaignController::class, 'sms'])->name('sms');
        Route::get('/tavsiye', [CampaignController::class, 'referral'])->name('referral');
    });
    
    // Ayarlar
    Route::prefix('ayarlar')->name('settings.')->group(function () {
        Route::get('/uyelik', [SettingsController::class, 'membership'])->name('membership');
        Route::post('/uyelik', [SettingsController::class, 'updateMembership']);
        Route::get('/muhasebe-grup', [SettingsController::class, 'accounting'])->name('accounting');
        Route::post('/muhasebe-grup', [SettingsController::class, 'updateAccounting']);
        Route::get('/rezervasyon-form', [SettingsController::class, 'reservationForm'])->name('reservation-form');
        Route::post('/rezervasyon-form', [SettingsController::class, 'updateReservationForm']);
        Route::get('/takvim', [SettingsController::class, 'calendar'])->name('calendar');
        Route::post('/takvim', [SettingsController::class, 'updateCalendar']);
        Route::get('/sozlesme-grup', [ContractController::class, 'index'])->name('contracts.index');
        Route::get('/sozlesme-grup/olustur', [ContractController::class, 'create'])->name('contracts.create');
        Route::post('/sozlesme-grup', [ContractController::class, 'store'])->name('contracts.store');
        Route::get('/sozlesme-grup/{id}/duzenle', [ContractController::class, 'edit'])->name('contracts.edit');
        Route::put('/sozlesme-grup/{id}', [ContractController::class, 'update'])->name('contracts.update');
        Route::delete('/sozlesme-grup/{id}', [ContractController::class, 'destroy'])->name('contracts.destroy');
        Route::post('/sozlesme-grup/{id}/varsayilan', [ContractController::class, 'setDefault'])->name('contracts.set-default');
        Route::get('/sozlesme/varsayilan-url', [ContractController::class, 'getDefaultContractUrl'])->name('contracts.default-url');
        Route::get('/sozlesme/rezervasyon/{reservationId}', [ContractController::class, 'showForReservation'])->name('contracts.show-reservation');
        Route::get('/menuler', [MenuController::class, 'index'])->name('menus.index');
        Route::get('/menuler/olustur', [MenuController::class, 'create'])->name('menus.create');
        Route::post('/menuler', [MenuController::class, 'store'])->name('menus.store');
        Route::get('/menuler/{id}/duzenle', [MenuController::class, 'edit'])->name('menus.edit');
        Route::put('/menuler/{id}', [MenuController::class, 'update'])->name('menus.update');
        Route::delete('/menuler/{id}', [MenuController::class, 'destroy'])->name('menus.destroy');
        Route::get('/extralar', [ExtraController::class, 'index'])->name('extras.index');
        Route::get('/extralar/olustur', [ExtraController::class, 'create'])->name('extras.create');
        Route::post('/extralar', [ExtraController::class, 'store'])->name('extras.store');
        Route::get('/extralar/{id}/duzenle', [ExtraController::class, 'edit'])->name('extras.edit');
        Route::put('/extralar/{id}', [ExtraController::class, 'update'])->name('extras.update');
        Route::delete('/extralar/{id}', [ExtraController::class, 'destroy'])->name('extras.destroy');
        Route::get('/salon-yonetimi', [SalonController::class, 'index'])->name('salons.index');
        Route::get('/salon-yonetimi/olustur', [SalonController::class, 'create'])->name('salons.create');
        Route::post('/salon-yonetimi', [SalonController::class, 'store'])->name('salons.store');
        Route::get('/salon-yonetimi/{id}/duzenle', [SalonController::class, 'edit'])->name('salons.edit');
        Route::put('/salon-yonetimi/{id}', [SalonController::class, 'update'])->name('salons.update');
        Route::delete('/salon-yonetimi/{id}', [SalonController::class, 'destroy'])->name('salons.destroy');
        Route::get('/email-bildirim', [SettingsController::class, 'email'])->name('email');
        Route::post('/email-bildirim', [SettingsController::class, 'updateEmail']);
        Route::get('/sms', [SettingsController::class, 'sms'])->name('sms');
        Route::post('/sms', [SettingsController::class, 'updateSms'])->name('sms.update');
        Route::post('/sms/test', [SettingsController::class, 'testSms'])->name('sms.test');
        Route::get('/whatsapp-fatura', [SettingsController::class, 'whatsappInvoice'])->name('whatsapp-invoice');
        Route::post('/whatsapp-fatura', [SettingsController::class, 'updateWhatsappInvoice']);
        Route::get('/ana-sayfa', [SettingsController::class, 'homepage'])->name('homepage');
        Route::post('/ana-sayfa', [SettingsController::class, 'updateHomepage'])->name('homepage.update');
        Route::get('/genel-ayarlar', [SettingsController::class, 'general'])->name('general');
        Route::post('/genel-ayarlar', [SettingsController::class, 'updateGeneral'])->name('general.update');
        Route::get('/faturalar', [InvoiceController::class, 'index'])->name('invoices.index');
        Route::get('/faturalar/{id}/pdf', [InvoiceController::class, 'showPdf'])->name('invoices.pdf');
        Route::post('/faturalar/{id}/sms', [InvoiceController::class, 'sendSms'])->name('invoices.send-sms');
        Route::get('/islemler', [ProcessController::class, 'index'])->name('processes.index');
        Route::get('/islemler/olustur', [ProcessController::class, 'create'])->name('processes.create');
        Route::post('/islemler', [ProcessController::class, 'store'])->name('processes.store');
        Route::get('/islemler/{id}/duzenle', [ProcessController::class, 'edit'])->name('processes.edit');
        Route::put('/islemler/{id}', [ProcessController::class, 'update'])->name('processes.update');
        Route::delete('/islemler/{id}', [ProcessController::class, 'destroy'])->name('processes.destroy');
        Route::get('/servisler', [ServiceController::class, 'index'])->name('services.index');
        Route::get('/servisler/olustur', [ServiceController::class, 'create'])->name('services.create');
        Route::post('/servisler', [ServiceController::class, 'store'])->name('services.store');
        Route::get('/servisler/{id}/duzenle', [ServiceController::class, 'edit'])->name('services.edit');
        Route::put('/servisler/{id}', [ServiceController::class, 'update'])->name('services.update');
        Route::delete('/servisler/{id}', [ServiceController::class, 'destroy'])->name('services.destroy');
    });
    
    // Salonlar (Rezervasyoncu için ana menü - settings.salons.index ile aynı view)
    Route::get('/salonlar', [SalonController::class, 'index'])->name('salons.index');
    Route::post('/salonlar', [SalonController::class, 'store'])->name('salons.store');
    
    // Muhasebe
    Route::prefix('muhasebe')->name('accounting.')->group(function () {
        Route::get('/gelirler', [AccountingController::class, 'income'])->name('income');
        Route::post('/gelirler', [AccountingController::class, 'storeIncome'])->name('income.store');
        Route::get('/giderler', [AccountingController::class, 'expense'])->name('expense');
        Route::post('/giderler', [AccountingController::class, 'storeExpense'])->name('expense.store');
        Route::get('/cariler', [CustomerAccountController::class, 'index'])->name('customers');
        Route::get('/cariler/{id}', [CustomerAccountController::class, 'show'])->name('customers.show');
        Route::get('/rezervasyon-gelirleri', [AccountingController::class, 'reservationIncome'])->name('reservation-income');
        Route::get('/gelecek-kaporalar', [AccountingController::class, 'deposits'])->name('deposits');
        Route::get('/kalan-bakiyeler', [AccountingController::class, 'balances'])->name('balances');
        Route::get('/kasa', [CashboxController::class, 'index'])->name('cashbox');
        Route::post('/kasa/gelir', [CashboxController::class, 'storeIncome'])->name('cashbox.income.store');
        Route::post('/kasa/gider', [CashboxController::class, 'storeExpense'])->name('cashbox.expense.store');
        Route::get('/kasa/rapor', [CashboxController::class, 'report'])->name('cashbox.report');
        Route::post('/kasa/yeniden-hesapla', [CashboxController::class, 'recalculate'])->name('cashbox.recalculate');
        Route::get('/kasa/{id}/fatura', [CashboxController::class, 'getInvoiceForTransaction'])->name('cashbox.invoice');
        Route::get('/kasa/{id}', [CashboxController::class, 'show'])->name('cashbox.show');
        Route::put('/kasa/{id}', [CashboxController::class, 'update'])->name('cashbox.update');
        Route::delete('/kasa/{id}', [CashboxController::class, 'destroy'])->name('cashbox.destroy');
    });
    
    // Raporlar
    Route::prefix('raporlar')->name('reports.')->group(function () {
        Route::get('/aylik-rezervasyon', [ReportController::class, 'monthlyReservations'])->name('monthly-reservations');
        Route::get('/aylik-gelir', [ReportController::class, 'monthlyRevenue'])->name('monthly-revenue');
        Route::get('/haftalik', [ReportController::class, 'weekly'])->name('weekly');
    });
    
    // Müşteriler
    Route::resource('musteriler', CustomerController::class)->names(['index' => 'customers.index', 'create' => 'customers.create', 'store' => 'customers.store', 'show' => 'customers.show', 'edit' => 'customers.edit', 'update' => 'customers.update', 'destroy' => 'customers.destroy']);
    Route::get('/musteriler/{id}/bakiye', [CustomerController::class, 'balance'])->name('customers.balance');
    Route::get('/api/musteriler/search', [CustomerController::class, 'search'])->name('customers.search');
    
    // Müşteri arama API (rezervasyon popup için - admin prefix dahil)
    Route::get('/musteriler/ara', [CustomerController::class, 'search'])->name('customers.ajax-search');
    
    // Telefon Rehberi - KALDIRILDI
    Route::resource('rehber', ContactController::class)->names(['index' => 'contacts.index', 'create' => 'contacts.create', 'store' => 'contacts.store', 'edit' => 'contacts.edit', 'update' => 'contacts.update', 'destroy' => 'contacts.destroy']);
    
    // Firmalarım / Adminler
    Route::resource('firmalar', CompanyController::class)->names(['index' => 'companies.index', 'create' => 'companies.create', 'store' => 'companies.store', 'edit' => 'companies.edit', 'update' => 'companies.update', 'destroy' => 'companies.destroy']);
    
    // Randevu Yönetimi
    Route::resource('randevular', AppointmentController::class)->names(['index' => 'appointments.index', 'create' => 'appointments.create', 'store' => 'appointments.store', 'edit' => 'appointments.edit', 'update' => 'appointments.update', 'destroy' => 'appointments.destroy']);
    
    // Hesap Yönetimi
    Route::get('/hesap', [AccountController::class, 'index'])->name('account.index');
    Route::put('/hesap', [AccountController::class, 'update'])->name('account.update');
    Route::post('/hesap/send-delete-otp', [AccountController::class, 'sendDeleteOtp'])->name('account.send-delete-otp');
    Route::delete('/hesap', [AccountController::class, 'destroy'])->name('account.destroy');
    
    // Yardım
    Route::get('/yardim/sss', [HelpController::class, 'faq'])->name('help.faq');
    Route::get('/yardim/destek', [HelpController::class, 'support'])->name('help.support');
    Route::post('/yardim/destek', [HelpController::class, 'submitSupport'])->name('help.submit');
    
    // Arama
    Route::get('/search', [SearchController::class, 'search'])->name('search');
    
    // Bildirimler
    Route::get('/bildirimler', [\App\Http\Controllers\Admin\NotificationController::class, 'index'])->name('notifications.index');
    Route::get('/api/bugunku-rezervasyonlar', [\App\Http\Controllers\Admin\NotificationController::class, 'todayReservations'])->name('notifications.today');
    Route::get('/api/yaklasan-rezervasyonlar', [\App\Http\Controllers\Admin\NotificationController::class, 'upcomingReservations'])->name('notifications.upcoming');
    
    // SMS Paketleri
    Route::get('/sms-paketleri', [\App\Http\Controllers\Admin\SmsPackageController::class, 'index'])->name('sms-packages.index');
    
    // Süper Admin Routes (admin prefix altında)
    Route::get('/superadmin', [SuperAdminController::class, 'dashboard'])->name('superadmin.dashboard');
    
    // Kullanıcı Yönetimi
    Route::get('/kullanicilar', [SuperAdminController::class, 'users'])->name('superadmin.users');
    Route::get('/kullanicilar/olustur', [SuperAdminController::class, 'createUser'])->name('superadmin.users.create');
    Route::post('/kullanicilar', [SuperAdminController::class, 'storeUser'])->name('superadmin.users.store');
    Route::get('/kullanicilar/{id}', [SuperAdminController::class, 'showUser'])->name('superadmin.users.show');
    Route::get('/kullanicilar/{id}/duzenle', [SuperAdminController::class, 'editUser'])->name('superadmin.users.edit');
    Route::put('/kullanicilar/{id}', [SuperAdminController::class, 'updateUser'])->name('superadmin.users.update');
    Route::delete('/kullanicilar/{id}', [SuperAdminController::class, 'destroyUser'])->name('superadmin.users.destroy');
    
    // SMS ve Lisans Yönetimi
    Route::get('/kullanicilar-yonetim', [\App\Http\Controllers\SuperAdmin\UserManagementController::class, 'index'])->name('superadmin.user-management');
    Route::post('/kullanicilar/{id}/sms-bakiye', [\App\Http\Controllers\SuperAdmin\UserManagementController::class, 'updateSmsBalance'])->name('superadmin.update-sms-balance');
    Route::post('/kullanicilar/{id}/lisans', [\App\Http\Controllers\SuperAdmin\UserManagementController::class, 'updateLicense'])->name('superadmin.update-license');
    
    // Firma Yönetimi
    Route::get('/firmalar-yonetim', [SuperAdminController::class, 'companies'])->name('superadmin.companies');
    Route::get('/firmalar-yonetim/olustur', [SuperAdminController::class, 'createCompany'])->name('superadmin.companies.create');
    Route::post('/firmalar-yonetim', [SuperAdminController::class, 'storeCompany'])->name('superadmin.companies.store');
    Route::get('/firmalar-yonetim/{id}', [SuperAdminController::class, 'showCompany'])->name('superadmin.companies.show');
    Route::get('/firmalar-yonetim/{id}/duzenle', [SuperAdminController::class, 'editCompany'])->name('superadmin.companies.edit');
    Route::put('/firmalar-yonetim/{id}', [SuperAdminController::class, 'updateCompany'])->name('superadmin.companies.update');
    Route::delete('/firmalar-yonetim/{id}', [SuperAdminController::class, 'destroyCompany'])->name('superadmin.companies.destroy');
    
    // Paket Yönetimi
    Route::prefix('paketler')->name('superadmin.packages.')->group(function () {
        Route::get('/', [\App\Http\Controllers\SuperAdmin\PackageController::class, 'index'])->name('index');
        Route::get('/create', [\App\Http\Controllers\SuperAdmin\PackageController::class, 'create'])->name('create');
        Route::post('/', [\App\Http\Controllers\SuperAdmin\PackageController::class, 'store'])->name('store');
        Route::get('/{id}/edit', [\App\Http\Controllers\SuperAdmin\PackageController::class, 'edit'])->name('edit');
        Route::put('/{id}', [\App\Http\Controllers\SuperAdmin\PackageController::class, 'update'])->name('update');
        Route::delete('/{id}', [\App\Http\Controllers\SuperAdmin\PackageController::class, 'destroy'])->name('destroy');
    });
    
    // Paket Seçimi (Ana Sayfa için)
    Route::get('/paket-secimi', [SuperAdminController::class, 'pricingSettings'])->name('superadmin.pricing-settings');
    Route::post('/paket-secimi', [SuperAdminController::class, 'updatePricingSettings'])->name('superadmin.pricing-settings.update');
    
    // Uygulama İndirme Linkleri Yönetimi
    Route::get('/uygulama-indirmeleri', [SuperAdminController::class, 'appDownloads'])->name('superadmin.app-downloads');
    Route::post('/uygulama-indirmeleri', [SuperAdminController::class, 'updateAppDownloads'])->name('superadmin.app-downloads.update');
    
    // Test SMS
    Route::get('/test-sms', [SuperAdminController::class, 'testSms'])->name('superadmin.test-sms');
    Route::post('/test-sms/send', [SuperAdminController::class, 'sendTestSms'])->name('superadmin.test-sms.send');
    Route::post('/test-sms/otp', [SuperAdminController::class, 'sendTestOtp'])->name('superadmin.test-sms.otp');
    
    // Test WhatsApp
    Route::get('/test-whatsapp', [SuperAdminController::class, 'testWhatsApp'])->name('superadmin.test-whatsapp');
    Route::post('/test-whatsapp/login/phone', [SuperAdminController::class, 'loginWithPhone'])->name('superadmin.test-whatsapp.login.phone');
    Route::post('/test-whatsapp/login/qr', [SuperAdminController::class, 'loginWithQr'])->name('superadmin.test-whatsapp.login.qr');
    Route::post('/test-whatsapp/login/check', [SuperAdminController::class, 'checkLogin'])->name('superadmin.test-whatsapp.login.check');
    Route::post('/test-whatsapp/send', [SuperAdminController::class, 'sendTestWhatsApp'])->name('superadmin.test-whatsapp.send');
    Route::get('/test-whatsapp/devices', [SuperAdminController::class, 'getDevices'])->name('superadmin.test-whatsapp.devices');
    
    // Müşteri Yorumları Yönetimi
    Route::prefix('musteri-yorumlari')->name('superadmin.testimonials.')->group(function () {
        Route::get('/', [\App\Http\Controllers\SuperAdmin\TestimonialController::class, 'index'])->name('index');
        Route::get('/create', [\App\Http\Controllers\SuperAdmin\TestimonialController::class, 'create'])->name('create');
        Route::post('/', [\App\Http\Controllers\SuperAdmin\TestimonialController::class, 'store'])->name('store');
        Route::get('/{id}/edit', [\App\Http\Controllers\SuperAdmin\TestimonialController::class, 'edit'])->name('edit');
        Route::put('/{id}', [\App\Http\Controllers\SuperAdmin\TestimonialController::class, 'update'])->name('update');
        Route::delete('/{id}', [\App\Http\Controllers\SuperAdmin\TestimonialController::class, 'destroy'])->name('destroy');
    });
    
    // Global Sözleşme Yönetimi (Süper Admin)
    Route::prefix('global-sozlesme')->name('superadmin.global-contract.')->group(function () {
        Route::get('/', [\App\Http\Controllers\SuperAdmin\GlobalContractController::class, 'index'])->name('index');
        Route::post('/', [\App\Http\Controllers\SuperAdmin\GlobalContractController::class, 'store'])->name('store');
        Route::delete('/', [\App\Http\Controllers\SuperAdmin\GlobalContractController::class, 'destroy'])->name('destroy');
    });
    
    // Fatura Yönetimi (Admin)
    Route::prefix('faturalar')->name('invoices.')->group(function () {
        Route::get('/{id}/download-pdf', [InvoiceController::class, 'downloadPdf'])->name('download-pdf');
        Route::post('/{id}/send-whatsapp', [InvoiceController::class, 'sendWhatsApp'])->name('send-whatsapp');
        Route::delete('/{id}', [InvoiceController::class, 'destroy'])->name('destroy');
    });
});

// Public Fatura Görüntüleme (Giriş gerektirmez)
Route::get('/fatura/{token}', [\App\Http\Controllers\PublicInvoiceController::class, 'show'])->name('public.invoice');
Route::get('/fatura/{token}/pdf', [\App\Http\Controllers\PublicInvoiceController::class, 'downloadPdf'])->name('public.invoice.pdf');

// Public Sözleşme Görüntüleme (Giriş gerektirmez)
Route::get('/sozlesme/{token}', [\App\Http\Controllers\PublicContractController::class, 'show'])->name('public.contract');
