<?php

require __DIR__ . '/vendor/autoload.php';

echo "🔍 Sanctum Kurulum Kontrolü\n";
echo "════════════════════════════════════════\n\n";

// 1. Sanctum paketini kontrol et
if (class_exists('Laravel\Sanctum\Sanctum')) {
    echo "✅ Sanctum paketi kurulu\n";
} else {
    echo "❌ Sanctum paketi bulunamadı\n";
}

// 2. HasApiTokens trait'ini kontrol et
if (trait_exists('Laravel\Sanctum\HasApiTokens')) {
    echo "✅ HasApiTokens trait mevcut\n";
} else {
    echo "❌ HasApiTokens trait bulunamadı\n";
}

// 3. PersonalAccessToken model'ini kontrol et
if (class_exists('Laravel\Sanctum\PersonalAccessToken')) {
    echo "✅ PersonalAccessToken model mevcut\n";
} else {
    echo "❌ PersonalAccessToken model bulunamadı\n";
}

// 4. User model'de HasApiTokens kontrolü
$userModelFile = __DIR__ . '/app/Models/User.php';
if (file_exists($userModelFile)) {
    $content = file_get_contents($userModelFile);
    if (strpos($content, 'HasApiTokens') !== false && strpos($content, 'use Laravel\\Sanctum\\HasApiTokens') !== false) {
        echo "✅ User model'de HasApiTokens trait ekli\n";
    } else {
        echo "❌ User model'de HasApiTokens trait eksik\n";
    }
} else {
    echo "❌ User model dosyası bulunamadı\n";
}

// 5. Migration tablosunu kontrol et (database'e bağlanmadan)
$migrationPath = __DIR__ . '/database/migrations';
if (is_dir($migrationPath)) {
    $migrations = glob($migrationPath . '/*_create_personal_access_tokens_table.php');
    if (!empty($migrations)) {
        echo "✅ Sanctum migration dosyası mevcut\n";
    } else {
        echo "⚠️  Sanctum migration dosyası bulunamadı (normal olabilir, Laravel 11+)\n";
    }
}

echo "\n════════════════════════════════════════\n";
echo "✅ Kontrol tamamlandı!\n";

