<?php

return [

    'default' => env('SMS_DEFAULT_PROVIDER', '1sms'),

    'providers' => [
        '1sms' => [
            'base_url' => env('SMS_1SMS_BASE_URL', 'https://api.1sms.com.tr'),
            'timeout' => env('SMS_1SMS_TIMEOUT', 30),
            'retry_times' => env('SMS_1SMS_RETRY', 3),
            'retry_delay' => env('SMS_1SMS_RETRY_DELAY', 1000),

            'auth' => [
                'type' => env('SMS_1SMS_AUTH_TYPE', 'xml'), 
                'username' => env('SMS_1SMS_USERNAME'),
                'password' => env('SMS_1SMS_PASSWORD'), 
            ],

            'endpoints' => [
                'send' => env('SMS_1SMS_ENDPOINT_SEND', '/api/smspost/v1'),
                'status' => env('SMS_1SMS_ENDPOINT_STATUS', '/api/dlr/v1'),
            ],

            'sender' => env('SMS_1SMS_SENDER', 'SALONAY'), 
            'validity' => env('SMS_1SMS_VALIDITY', 2880), 
        ],
    ],

    'queue' => [
        'enabled' => env('SMS_QUEUE_ENABLED', false),
        'connection' => env('SMS_QUEUE_CONNECTION', 'sync'),
        'queue' => env('SMS_QUEUE_NAME', 'default'),
    ],

    'otp' => [
        'length' => env('SMS_OTP_LENGTH', 6),
        'expiry' => env('SMS_OTP_EXPIRY', 300), 
        'prefix' => env('SMS_OTP_PREFIX', 'otp:'),
        'message_template' => env('SMS_OTP_MESSAGE_TEMPLATE', 'Doğrulama kodunuz: {code}'),
    ],

    'rate_limit' => [
        'enabled' => env('SMS_RATE_LIMIT_ENABLED', true),
        'max_attempts_per_minute' => env('SMS_RATE_LIMIT_PER_MINUTE', 3),
        'max_attempts_per_10_minutes' => env('SMS_RATE_LIMIT_PER_10_MINUTES', 8),
    ],

    'phone' => [
        'default_country_code' => env('SMS_PHONE_DEFAULT_COUNTRY', 'TR'),
        'country_code' => env('SMS_PHONE_COUNTRY_CODE', '+90'),
        'normalize_tr' => env('SMS_PHONE_NORMALIZE_TR', true),
    ],

    'webhook' => [
        'enabled' => env('SMS_WEBHOOK_ENABLED', true),
        'secret' => env('SMS_WEBHOOK_SECRET'),
        'header_token' => env('SMS_WEBHOOK_HEADER_TOKEN', 'X-SMS-Webhook-Token'),
    ],

    'segmentation' => [
        'enabled' => env('SMS_SEGMENTATION_ENABLED', true),
        'gsm_7bit_length' => env('SMS_SEGMENTATION_GSM_7BIT', 160),
        'gsm_7bit_multipart' => env('SMS_SEGMENTATION_GSM_7BIT_MULTIPART', 153),
        'ucs2_length' => env('SMS_SEGMENTATION_UCS2', 70),
        'ucs2_multipart' => env('SMS_SEGMENTATION_UCS2_MULTIPART', 67),
    ],
];

