<?php

return [

    'default' => env('WHATSAPP_DEFAULT_PROVIDER', 'vatansms'),

    'providers' => [
        'vatansms' => [
            'base_url' => env('WHATSAPP_VATANSMS_BASE_URL', 'https://api.vatansms.com.tr'),
            'timeout' => env('WHATSAPP_VATANSMS_TIMEOUT', 30),
            'retry_times' => env('WHATSAPP_VATANSMS_RETRY', 3),
            'retry_delay' => env('WHATSAPP_VATANSMS_RETRY_DELAY', 1000),

            'auth' => [
                'client_id' => env('WHATSAPP_VATANSMS_CLIENT_ID'),
                'client_secret' => env('WHATSAPP_VATANSMS_CLIENT_SECRET'),
            ],
        ],
    ],

    'phone' => [
        'default_country_code' => env('WHATSAPP_PHONE_DEFAULT_COUNTRY', 'TR'),
        'country_code' => env('WHATSAPP_PHONE_COUNTRY_CODE', '+90'),
        'normalize_tr' => env('WHATSAPP_PHONE_NORMALIZE_TR', true),
    ],

    'callback' => [
        'enabled' => env('WHATSAPP_CALLBACK_ENABLED', true),
        'secret' => env('WHATSAPP_CALLBACK_SECRET'),
        'url' => env('WHATSAPP_CALLBACK_URL'),
    ],
];

