<?php

namespace Database\Factories;

use App\Models\SmsLog;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\SmsLog>
 */
class SmsLogFactory extends Factory
{
    protected $model = SmsLog::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'provider' => 'interaktif_sms',
            'to' => '+90' . fake()->numerify('5##########'),
            'message' => fake()->sentence(),
            'purpose' => null,
            'status' => fake()->randomElement(['queued', 'sent', 'delivered', 'failed']),
            'provider_message_id' => fake()->uuid(),
            'error_code' => null,
            'error_message' => null,
            'raw_request' => null,
            'raw_response' => null,
            'sent_at' => fake()->optional()->dateTime(),
            'delivered_at' => fake()->optional()->dateTime(),
        ];
    }
}

