<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('notification_devices', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->string('device_token', 255)->unique();
            $table->enum('platform', ['ios', 'android'])->default('ios');
            $table->string('app_version', 20)->nullable();
            $table->string('os_version', 20)->nullable();
            $table->timestamp('last_seen_at')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();
            
            $table->index(['user_id', 'is_active']);
            $table->index('device_token');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('notification_devices');
    }
};

