<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (!Schema::hasTable('notifications')) {
            Schema::create('notifications', function (Blueprint $table) {
                $table->uuid('id')->primary();
                $table->string('type');
                $table->morphs('notifiable');
                $table->text('data');
                $table->timestamp('read_at')->nullable();
                $table->timestamps();
                
                $table->index(['notifiable_type', 'notifiable_id']);
                $table->index('read_at');
                $table->index('created_at');
            });
        } else {
            try {
                Schema::table('notifications', function (Blueprint $table) {
                    try {
                        $table->index(['notifiable_type', 'notifiable_id'], 'notifications_notifiable_index');
                    } catch (\Exception $e) {
                    }
                    try {
                        $table->index('read_at', 'notifications_read_at_index');
                    } catch (\Exception $e) {
                    }
                    try {
                        $table->index('created_at', 'notifications_created_at_index');
                    } catch (\Exception $e) {
                    }
                });
            } catch (\Exception $e) {
            }
        }
    }

    public function down(): void
    {
        Schema::dropIfExists('notifications');
    }
};

