<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('transactions', function (Blueprint $table) {
            if (!Schema::hasColumn('transactions', 'date')) {
                $table->date('date')->nullable()->after('amount');
            }
            
            if (!Schema::hasColumn('transactions', 'customer_id')) {
                $table->foreignId('customer_id')->nullable()->after('reservation_id')->constrained('customers')->onDelete('set null');
            }
            
            if (!Schema::hasColumn('transactions', 'created_by')) {
                $table->foreignId('created_by')->nullable()->after('description')->constrained('users')->onDelete('set null');
            }
        });
    }

    public function down(): void
    {
        Schema::table('transactions', function (Blueprint $table) {
            if (Schema::hasColumn('transactions', 'created_by')) {
                $table->dropForeign(['created_by']);
                $table->dropColumn('created_by');
            }
            
            if (Schema::hasColumn('transactions', 'customer_id')) {
                $table->dropForeign(['customer_id']);
                $table->dropColumn('customer_id');
            }
            
            if (Schema::hasColumn('transactions', 'date')) {
                $table->dropColumn('date');
            }
        });
    }
};
