<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        $hasColumn = false;
        try {
            $columns = DB::select("SHOW COLUMNS FROM reservations LIKE 'date'");
            $hasColumn = count($columns) > 0;
        } catch (\Exception $e) {
        }
        
        if (!$hasColumn) {
            Schema::table('reservations', function (Blueprint $table) {
                $table->date('date')->after('salon_id');
            });
        }
    }

    public function down(): void
    {
        Schema::table('reservations', function (Blueprint $table) {
            $table->dropColumn('date');
        });
    }
};
