<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        try {
            Schema::table('users', function (Blueprint $table) {
                $table->dropUnique(['email']);
            });
        } catch (\Exception $e) {
        }

        try {
            DB::statement('ALTER TABLE users MODIFY COLUMN email VARCHAR(255) NULL');
        } catch (\Exception $e) {
        }

        try {
            Schema::table('users', function (Blueprint $table) {
                $table->unique('phone');
            });
        } catch (\Exception $e) {
        }
    }

    public function down(): void
    {
        try {
            Schema::table('users', function (Blueprint $table) {
                $table->dropUnique(['phone']);
            });
        } catch (\Exception $e) {
        }

        try {
            Schema::table('users', function (Blueprint $table) {
                $table->unique('email');
            });
        } catch (\Exception $e) {
        }
    }
};
