<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('reservations', function (Blueprint $table) {
            if (!Schema::hasColumn('reservations', 'deposit_paid')) {
                $table->decimal('deposit_paid', 10, 2)->default(0)->after('total_price');
            }
            if (!Schema::hasColumn('reservations', 'remaining_amount')) {
                $table->decimal('remaining_amount', 10, 2)->default(0)->after('deposit_paid');
            }
        });
    }

    public function down(): void
    {
        Schema::table('reservations', function (Blueprint $table) {
            $table->dropColumn(['deposit_paid', 'remaining_amount']);
        });
    }
};
