<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('invoices', function (Blueprint $table) {
            
            if (!Schema::hasColumn('invoices', 'public_token')) {
                $table->string('public_token', 64)->unique()->nullable()->after('status');
            }
            if (!Schema::hasColumn('invoices', 'public_url')) {
                $table->text('public_url')->nullable()->after('public_token');
            }
            if (!Schema::hasColumn('invoices', 'is_approved')) {
                $table->boolean('is_approved')->default(false)->after('public_url');
            }
            if (!Schema::hasColumn('invoices', 'approved_at')) {
                $table->timestamp('approved_at')->nullable()->after('is_approved');
            }
            if (!Schema::hasColumn('invoices', 'approved_by')) {
                $table->unsignedBigInteger('approved_by')->nullable()->after('approved_at');
            }
        });
        
        try {
            Schema::table('invoices', function (Blueprint $table) {
                if (Schema::hasColumn('invoices', 'approved_by')) {
                    $table->foreign('approved_by')->references('id')->on('users')->onDelete('set null');
                }
            });
        } catch (\Exception $e) {
        }
    }

    public function down(): void
    {
        Schema::table('invoices', function (Blueprint $table) {
            try {
                $table->dropForeign(['approved_by']);
            } catch (\Exception $e) {
            }
            
            $columns = ['public_token', 'public_url', 'is_approved', 'approved_at', 'approved_by'];
            foreach ($columns as $column) {
                if (Schema::hasColumn('invoices', $column)) {
                    $table->dropColumn($column);
                }
            }
        });
    }
};
