<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        DB::statement("ALTER TABLE `invoices` MODIFY COLUMN `status` ENUM('draft', 'sent', 'paid', 'cancelled', 'approved') DEFAULT 'draft'");
    }

    public function down(): void
    {
        DB::statement("UPDATE `invoices` SET `status` = 'draft' WHERE `status` = 'approved'");
        DB::statement("ALTER TABLE `invoices` MODIFY COLUMN `status` ENUM('draft', 'sent', 'paid', 'cancelled') DEFAULT 'draft'");
    }
};
