<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('invoices', function (Blueprint $table) {
            if (!Schema::hasColumn('invoices', 'deposit_paid')) {
                $table->decimal('deposit_paid', 10, 2)->default(0)->after('total_amount');
            }
            if (!Schema::hasColumn('invoices', 'remaining_amount')) {
                $table->decimal('remaining_amount', 10, 2)->default(0)->after('deposit_paid');
            }
            if (!Schema::hasColumn('invoices', 'pdf_path')) {
                $table->string('pdf_path')->nullable()->after('status');
            }
            if (!Schema::hasColumn('invoices', 'items_json')) {
                $table->json('items_json')->nullable()->after('pdf_path');
            }
        });
    }

    public function down(): void
    {
        Schema::table('invoices', function (Blueprint $table) {
            if (Schema::hasColumn('invoices', 'deposit_paid')) {
                $table->dropColumn('deposit_paid');
            }
            if (Schema::hasColumn('invoices', 'remaining_amount')) {
                $table->dropColumn('remaining_amount');
            }
            if (Schema::hasColumn('invoices', 'pdf_path')) {
                $table->dropColumn('pdf_path');
            }
            if (Schema::hasColumn('invoices', 'items_json')) {
                $table->dropColumn('items_json');
            }
        });
    }
};
