<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('contracts', function (Blueprint $table) {
            $table->boolean('is_default')->default(false)->after('is_active');
            $table->string('public_token', 64)->nullable()->unique()->after('is_default');
            $table->unsignedBigInteger('company_id')->nullable()->after('id');
            
            $table->foreign('company_id')->references('id')->on('companies')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::table('contracts', function (Blueprint $table) {
            $table->dropForeign(['company_id']);
            $table->dropColumn(['is_default', 'public_token', 'company_id']);
        });
    }
};
