<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('sms_logs', function (Blueprint $table) {
            if (!Schema::hasColumn('sms_logs', 'provider')) {
                $table->string('provider', 50)->nullable()->after('id');
            }
            if (!Schema::hasColumn('sms_logs', 'to')) {
                if (Schema::hasColumn('sms_logs', 'to_phone')) {
                    $table->renameColumn('to_phone', 'to');
                } else {
                    $table->string('to', 20)->after('provider');
                }
            }
            if (!Schema::hasColumn('sms_logs', 'purpose')) {
                $table->string('purpose', 50)->nullable()->after('message');
            }
            if (!Schema::hasColumn('sms_logs', 'provider_message_id')) {
                $table->string('provider_message_id', 100)->nullable()->after('purpose');
            }
            if (!Schema::hasColumn('sms_logs', 'error_code')) {
                $table->string('error_code', 50)->nullable()->after('provider_message_id');
            }
            if (!Schema::hasColumn('sms_logs', 'error_message')) {
                $table->text('error_message')->nullable()->after('error_code');
            }
            if (!Schema::hasColumn('sms_logs', 'raw_request')) {
                $table->json('raw_request')->nullable()->after('error_message');
            }
            if (!Schema::hasColumn('sms_logs', 'raw_response')) {
                $table->json('raw_response')->nullable()->after('raw_request');
            }
            if (!Schema::hasColumn('sms_logs', 'sent_at')) {
                $table->timestamp('sent_at')->nullable()->after('raw_response');
            }
            if (!Schema::hasColumn('sms_logs', 'delivered_at')) {
                $table->timestamp('delivered_at')->nullable()->after('sent_at');
            }

            if (Schema::hasColumn('sms_logs', 'status')) {
                $table->string('status', 20)->default('queued')->change();
            } else {
                $table->string('status', 20)->default('queued')->after('delivered_at');
            }
        });

        \DB::table('sms_logs')
            ->where('status', 'pending')
            ->update(['status' => 'queued']);
    }

    public function down(): void
    {
        Schema::table('sms_logs', function (Blueprint $table) {
            $columns = [
                'provider',
                'purpose',
                'provider_message_id',
                'error_code',
                'error_message',
                'raw_request',
                'raw_response',
                'sent_at',
                'delivered_at',
            ];

            foreach ($columns as $column) {
                if (Schema::hasColumn('sms_logs', $column)) {
                    $table->dropColumn($column);
                }
            }

            if (Schema::hasColumn('sms_logs', 'status')) {
                \DB::table('sms_logs')
                    ->where('status', 'queued')
                    ->update(['status' => 'pending']);
            }
        });
    }
};

