<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('sms_logs', function (Blueprint $table) {
            if (Schema::hasColumn('sms_logs', 'phone') && !Schema::hasColumn('sms_logs', 'to')) {
                DB::statement('ALTER TABLE `sms_logs` CHANGE `phone` `to` VARCHAR(20) NOT NULL');
            }
            
            if (Schema::hasColumn('sms_logs', 'to_phone') && !Schema::hasColumn('sms_logs', 'to')) {
                DB::statement('ALTER TABLE `sms_logs` CHANGE `to_phone` `to` VARCHAR(20) NOT NULL');
            }
            
            if (Schema::hasColumn('sms_logs', 'phone') && Schema::hasColumn('sms_logs', 'to')) {
                $table->dropColumn('phone');
            }
            
            if (!Schema::hasColumn('sms_logs', 'to')) {
                $table->string('to', 20)->after('provider')->nullable(false);
            }
        });
    }

    public function down(): void
    {
    }
};

