<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('whatsapp_sessions', function (Blueprint $table) {
            $table->id();
            $table->string('provider')->default('vatansms');
            $table->string('reg_id')->unique();
            $table->string('device_number')->nullable();
            $table->string('platform')->nullable();
            $table->string('user_name')->nullable();
            $table->string('j_id')->nullable();
            $table->string('state')->nullable();
            $table->boolean('is_active')->default(true);
            $table->boolean('is_connected')->default(false);
            $table->timestamp('connected_at')->nullable();
            $table->timestamp('last_activity_at')->nullable();
            $table->text('profile_picture')->nullable();
            $table->json('metadata')->nullable();
            $table->timestamps();

            $table->index('reg_id');
            $table->index('provider');
            $table->index('is_active');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('whatsapp_sessions');
    }
};
