<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('whatsapp_messages', function (Blueprint $table) {
            $table->id();
            $table->string('provider')->default('vatansms');
            $table->string('reg_id');
            $table->string('to');
            $table->text('message');
            $table->string('status')->default('pending'); 
            $table->bigInteger('report_id')->nullable();
            $table->string('send_speed')->default('1');
            $table->string('attachment_path')->nullable();
            $table->string('attachment_type')->nullable();
            $table->timestamp('sent_at')->nullable();
            $table->timestamp('delivered_at')->nullable();
            $table->text('error_message')->nullable();
            $table->json('raw_request')->nullable();
            $table->json('raw_response')->nullable();
            $table->json('callback_data')->nullable();
            $table->timestamps();

            $table->index('reg_id');
            $table->index('to');
            $table->index('status');
            $table->index('report_id');
            $table->index('provider');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('whatsapp_messages');
    }
};
