<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('reservations', function (Blueprint $table) {
            $table->string('bride_name')->nullable()->after('guest_count');
            $table->string('groom_name')->nullable()->after('bride_name');
            $table->string('bride_groom_phone')->nullable()->after('groom_name');
        });
    }

    public function down(): void
    {
        Schema::table('reservations', function (Blueprint $table) {
            $table->dropColumn(['bride_name', 'groom_name', 'bride_groom_phone']);
        });
    }
};
