<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('salon_name')->nullable()->after('name');
            $table->string('salon_short_name')->nullable()->after('salon_name');
            $table->string('salon_slug')->nullable()->unique()->after('salon_short_name');
            $table->string('salon_phone')->nullable()->after('salon_slug');
            $table->text('salon_address')->nullable()->after('salon_phone');
            $table->string('salon_profile_image')->nullable()->after('salon_address');
            $table->string('salon_theme')->default('theme1')->after('salon_profile_image');
            $table->text('salon_description')->nullable()->after('salon_theme');
            
            $table->foreignId('beauty_salon_id')->nullable()->after('company_id')->constrained('users')->onDelete('cascade');
            $table->json('personel_tags')->nullable()->after('beauty_salon_id'); 
        });
    }

    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropForeign(['beauty_salon_id']);
            $table->dropColumn([
                'salon_name',
                'salon_short_name',
                'salon_slug',
                'salon_phone',
                'salon_address',
                'salon_profile_image',
                'salon_theme',
                'salon_description',
                'beauty_salon_id',
                'personel_tags',
            ]);
        });
    }
};
