<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        DB::statement("ALTER TABLE users MODIFY COLUMN role ENUM('super_admin', 'admin', 'manager', 'staff', 'güzellik_salonu', 'personel') DEFAULT 'güzellik_salonu'");
        
        DB::table('users')->where('role', 'rezervasyoncu')->update(['role' => 'güzellik_salonu']);
    }

    public function down(): void
    {
        DB::table('users')->where('role', 'güzellik_salonu')->update(['role' => 'rezervasyoncu']);
        
        DB::statement("ALTER TABLE users MODIFY COLUMN role ENUM('super_admin', 'admin', 'manager', 'staff', 'personel', 'rezervasyoncu') DEFAULT 'rezervasyoncu'");
    }
};
