<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('customers', function (Blueprint $table) {
            if (!Schema::hasColumn('customers', 'beauty_salon_id')) {
                $table->unsignedBigInteger('beauty_salon_id')->nullable()->after('created_by');
                $table->foreign('beauty_salon_id')->references('id')->on('users')->onDelete('cascade');
            }
        });
    }

    public function down(): void
    {
        Schema::table('customers', function (Blueprint $table) {
            if (Schema::hasColumn('customers', 'beauty_salon_id')) {
                $table->dropForeign(['beauty_salon_id']);
                $table->dropColumn('beauty_salon_id');
            }
        });
    }
};
