<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (!Schema::hasTable('services')) {
            Schema::create('services', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('beauty_salon_id')->nullable(); 
                $table->string('name'); 
                $table->text('description')->nullable(); 
                $table->decimal('price', 10, 2)->default(0.00); 
                $table->integer('duration')->nullable(); 
                $table->boolean('is_active')->default(true);
                $table->timestamps();

                $table->foreign('beauty_salon_id')->references('id')->on('users')->onDelete('cascade');
                $table->index('beauty_salon_id');
            });
        } else {
            Schema::table('services', function (Blueprint $table) {
                if (!Schema::hasColumn('services', 'beauty_salon_id')) {
                    $table->unsignedBigInteger('beauty_salon_id')->nullable()->after('id');
                    $table->foreign('beauty_salon_id')->references('id')->on('users')->onDelete('cascade');
                    $table->index('beauty_salon_id');
                }
                
                if (!Schema::hasColumn('services', 'duration')) {
                    $table->integer('duration')->nullable()->after('price');
                }
            });
        }
    }

    public function down(): void
    {
        Schema::dropIfExists('services');
    }
};
