<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('appointment_requests', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('beauty_salon_id'); 
            $table->unsignedBigInteger('service_id')->nullable(); 
            $table->unsignedBigInteger('customer_id')->nullable(); 
            $table->string('name'); 
            $table->string('surname')->nullable(); 
            $table->integer('age')->nullable(); 
            $table->string('phone'); 
            $table->boolean('phone_verified')->default(false); 
            $table->string('otp_code')->nullable(); 
            $table->timestamp('otp_expires_at')->nullable(); 
            $table->enum('status', ['pending', 'approved', 'rejected', 'completed'])->default('pending'); 
            $table->date('appointment_date')->nullable(); 
            $table->time('appointment_time')->nullable(); 
            $table->unsignedBigInteger('personel_id')->nullable(); 
            $table->unsignedBigInteger('room_id')->nullable(); 
            $table->unsignedBigInteger('reservation_id')->nullable(); 
            $table->text('notes')->nullable(); 
            $table->timestamps();

            $table->foreign('beauty_salon_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('service_id')->references('id')->on('services')->onDelete('set null');
            $table->foreign('customer_id')->references('id')->on('customers')->onDelete('set null');
            $table->foreign('personel_id')->references('id')->on('users')->onDelete('set null');
            $table->foreign('room_id')->references('id')->on('rooms')->onDelete('set null');
            $table->foreign('reservation_id')->references('id')->on('reservations')->onDelete('set null');
            $table->index('beauty_salon_id');
            $table->index('status');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('appointment_requests');
    }
};
