<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        DB::statement("ALTER TABLE reservations MODIFY COLUMN status ENUM('open', 'bekleyen', 'confirmed', 'cancelled', 'completed') DEFAULT 'open'");
        
        DB::table('reservations')
            ->where('status', 'open')
            ->whereNull('date')
            ->orWhere('date', '0000-00-00')
            ->orWhere('date', '1970-01-01')
            ->update(['status' => 'bekleyen']);
    }

    public function down(): void
    {
        DB::table('reservations')
            ->where('status', 'bekleyen')
            ->update(['status' => 'open']);
        
        DB::statement("ALTER TABLE reservations MODIFY COLUMN status ENUM('open', 'confirmed', 'cancelled', 'completed') DEFAULT 'open'");
    }
};
