<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            if (!Schema::hasColumn('users', 'is_personel_admin')) {
                $table->boolean('is_personel_admin')->default(false)->after('beauty_salon_id');
            }
            
            if (!Schema::hasColumn('users', 'short_url')) {
                $table->string('short_url', 50)->nullable()->unique()->after('salon_slug');
            }
        });
    }

    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            if (Schema::hasColumn('users', 'is_personel_admin')) {
                $table->dropColumn('is_personel_admin');
            }
            if (Schema::hasColumn('users', 'short_url')) {
                $table->dropColumn('short_url');
            }
        });
    }
};
