<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('reservations', function (Blueprint $table) {
            $table->dropForeign(['salon_id']);
            $table->unsignedBigInteger('salon_id')->nullable()->change();
        });
    }

    public function down(): void
    {
        Schema::table('reservations', function (Blueprint $table) {
            $table->unsignedBigInteger('salon_id')->nullable(false)->change();
            $table->foreign('salon_id')->references('id')->on('salons')->onDelete('restrict');
        });
    }
};
