<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('service_categories', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('beauty_salon_id')->nullable();
            $table->string('name');
            $table->text('description')->nullable();
            $table->string('color')->default('#ec4899');
            $table->integer('sort_order')->default(0);
            $table->timestamps();

            $table->foreign('beauty_salon_id')->references('id')->on('users')->onDelete('cascade');
            $table->index('beauty_salon_id');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('service_categories');
    }
};
