<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('appointment_requests', function (Blueprint $table) {
            if (!Schema::hasColumn('appointment_requests', 'service_ids')) {
                $table->json('service_ids')->nullable()->after('service_id');
            }
        });
    }

    public function down(): void
    {
        Schema::table('appointment_requests', function (Blueprint $table) {
            if (Schema::hasColumn('appointment_requests', 'service_ids')) {
                $table->dropColumn('service_ids');
            }
        });
    }
};
