<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('salons', function (Blueprint $table) {
            $table->string('city', 100)->nullable()->after('address');
            $table->string('district', 100)->nullable()->after('city');
            
            $table->index('city');
            $table->index('district');
            $table->index(['city', 'district']);
        });
    }

    public function down(): void
    {
        Schema::table('salons', function (Blueprint $table) {
            $table->dropIndex(['city', 'district']);
            $table->dropIndex(['district']);
            $table->dropIndex(['city']);
            $table->dropColumn(['city', 'district']);
        });
    }
};
