<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('salon_ratings', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('salon_id'); 
            $table->unsignedBigInteger('customer_id')->nullable();
            $table->unsignedBigInteger('reservation_id')->nullable();
            $table->integer('rating')->default(0); 
            $table->text('comment')->nullable();
            $table->string('token', 12)->unique(); 
            $table->timestamp('expires_at')->nullable(); 
            $table->boolean('is_used')->default(false); 
            $table->string('customer_name')->nullable(); 
            $table->string('customer_phone')->nullable(); 
            $table->timestamps();
            
            $table->index('salon_id');
            $table->index('token');
            $table->index('is_used');
            $table->index('expires_at');
            
            $table->foreign('salon_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('customer_id')->references('id')->on('customers')->onDelete('set null');
            $table->foreign('reservation_id')->references('id')->on('reservations')->onDelete('set null');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('salon_ratings');
    }
};
