<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            if (!Schema::hasColumn('users', 'salon_city')) {
                $table->string('salon_city')->nullable()->after('salon_address');
            }
            if (!Schema::hasColumn('users', 'salon_district')) {
                $table->string('salon_district')->nullable()->after('salon_city');
            }
        });
    }

    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            if (Schema::hasColumn('users', 'salon_city')) {
                $table->dropColumn('salon_city');
            }
            if (Schema::hasColumn('users', 'salon_district')) {
                $table->dropColumn('salon_district');
            }
        });
    }
};
