<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // Referrals
        Schema::create('referrals', function (Blueprint $table) {
            $table->id();
            $table->foreignId('beauty_salon_id')->constrained('users')->onDelete('cascade');
            $table->foreignId('referrer_id')->constrained('customers')->onDelete('cascade'); // Referans eden müşteri
            $table->foreignId('referred_id')->nullable()->constrained('customers')->onDelete('set null'); // Yeni müşteri
            $table->string('referral_code')->unique(); // Benzersiz referans kodu
            $table->enum('status', ['pending', 'registered', 'first_visit', 'completed', 'rewarded'])->default('pending');
            $table->foreignId('first_appointment_id')->nullable()->constrained('appointments')->onDelete('set null');
            $table->timestamp('registered_at')->nullable();
            $table->timestamp('first_visit_at')->nullable();
            $table->timestamp('rewarded_at')->nullable();
            $table->string('ip_address')->nullable(); // Suistimal önleme
            $table->string('user_agent')->nullable();
            $table->json('metadata')->nullable();
            $table->timestamps();
            
            $table->index(['beauty_salon_id', 'referrer_id']);
            $table->index(['referral_code']);
        });

        // Referral Rewards
        Schema::create('referral_rewards', function (Blueprint $table) {
            $table->id();
            $table->foreignId('beauty_salon_id')->constrained('users')->onDelete('cascade');
            $table->enum('reward_type', ['discount', 'points', 'free_service', 'cash'])->default('discount');
            $table->decimal('referrer_reward_amount', 10, 2)->default(0); // Referans eden ödülü
            $table->decimal('referred_reward_amount', 10, 2)->default(0); // Yeni müşteri ödülü
            $table->decimal('referrer_reward_percentage', 5, 2)->nullable(); // Yüzde bazlı
            $table->decimal('referred_reward_percentage', 5, 2)->nullable();
            $table->integer('min_visits_required')->default(1); // Minimum ziyaret şartı
            $table->boolean('require_payment')->default(true); // Ödeme şartı
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });

        // Referral Reward History
        Schema::create('referral_reward_history', function (Blueprint $table) {
            $table->id();
            $table->foreignId('referral_id')->constrained('referrals')->onDelete('cascade');
            $table->foreignId('customer_id')->constrained()->onDelete('cascade');
            $table->enum('reward_for', ['referrer', 'referred'])->default('referrer');
            $table->enum('reward_type', ['discount', 'points', 'free_service', 'cash'])->default('discount');
            $table->decimal('reward_amount', 10, 2)->default(0);
            $table->foreignId('appointment_id')->nullable()->constrained('appointments')->onDelete('set null');
            $table->text('description')->nullable();
            $table->timestamps();
            
            $table->index(['referral_id', 'customer_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('referral_reward_history');
        Schema::dropIfExists('referral_rewards');
        Schema::dropIfExists('referrals');
    }
};
