<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('salon_ratings', function (Blueprint $table) {
            $table->string('referral_code', 6)->nullable()->after('token')->comment('6 haneli referans kodu (yeni müşteriler için)');
            $table->index('referral_code');
        });
    }

    public function down(): void
    {
        Schema::table('salon_ratings', function (Blueprint $table) {
            $table->dropIndex(['referral_code']);
            $table->dropColumn('referral_code');
        });
    }
};
