<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('customer_messages', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('beauty_salon_id');
            $table->string('message_type')->default('custom'); // custom, template
            $table->string('template_key')->nullable(); // Şablon anahtarı
            $table->text('message_content'); // Mesaj içeriği
            $table->json('customer_ids')->nullable(); // Hangi müşterilere gönderildi
            $table->integer('total_sent')->default(0); // Toplam gönderilen sayısı
            $table->integer('total_failed')->default(0); // Başarısız gönderim sayısı
            $table->string('send_method')->default('whatsapp'); // whatsapp, sms
            $table->timestamp('sent_at')->nullable();
            $table->timestamps();
            
            $table->foreign('beauty_salon_id')->references('id')->on('users')->onDelete('cascade');
            $table->index(['beauty_salon_id', 'sent_at']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('customer_messages');
    }
};
